package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import java.util.List;

public class EndpointSubsetFluentImpl<A extends EndpointSubsetFluent<A>> extends BaseFluent<A> implements EndpointSubsetFluent<A>{

     List<VisitableBuilder<EndpointAddress, ?>> addresses = new ArrayList();     List<VisitableBuilder<EndpointAddress, ?>> notReadyAddresses = new ArrayList();     List<VisitableBuilder<EndpointPort, ?>> ports = new ArrayList();
public EndpointSubsetFluentImpl(){
    
}
public EndpointSubsetFluentImpl( EndpointSubset instance ){
    this.withAddresses(instance.getAddresses()); this.withNotReadyAddresses(instance.getNotReadyAddresses()); this.withPorts(instance.getPorts()); 
}

    public A addToAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }
    public A removeFromAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.addresses.remove(builder);} return (A)this;
    }
    public List<EndpointAddress> getAddresses(){
    return build(addresses);
    }
    public A withAddresses( List<EndpointAddress> addresses){
    this.addresses.clear();if (addresses != null) {for (EndpointAddress item : addresses){this.addToAddresses(item);}} return (A) this;
    }
    public A withAddresses( EndpointAddress ...addresses){
    this.addresses.clear(); if (addresses != null) {for (EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }
    public AddressesNested<A> addNewAddresse(){
    return new AddressesNestedImpl();
    }
    public AddressesNested<A> addNewAddresseLike( EndpointAddress item){
    return new AddressesNestedImpl(item);
    }
    public A addToNotReadyAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (A)this;
    }
    public A removeFromNotReadyAddresses( EndpointAddress ...items){
    for (EndpointAddress item : items) {EndpointAddressBuilder builder = new EndpointAddressBuilder(item);_visitables.remove(builder);this.notReadyAddresses.remove(builder);} return (A)this;
    }
    public List<EndpointAddress> getNotReadyAddresses(){
    return build(notReadyAddresses);
    }
    public A withNotReadyAddresses( List<EndpointAddress> notReadyAddresses){
    this.notReadyAddresses.clear();if (notReadyAddresses != null) {for (EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} return (A) this;
    }
    public A withNotReadyAddresses( EndpointAddress ...notReadyAddresses){
    this.notReadyAddresses.clear(); if (notReadyAddresses != null) {for (EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
    }
    public NotReadyAddressesNested<A> addNewNotReadyAddresse(){
    return new NotReadyAddressesNestedImpl();
    }
    public NotReadyAddressesNested<A> addNewNotReadyAddresseLike( EndpointAddress item){
    return new NotReadyAddressesNestedImpl(item);
    }
    public A addToPorts( EndpointPort ...items){
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }
    public A removeFromPorts( EndpointPort ...items){
    for (EndpointPort item : items) {EndpointPortBuilder builder = new EndpointPortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (A)this;
    }
    public List<EndpointPort> getPorts(){
    return build(ports);
    }
    public A withPorts( List<EndpointPort> ports){
    this.ports.clear();if (ports != null) {for (EndpointPort item : ports){this.addToPorts(item);}} return (A) this;
    }
    public A withPorts( EndpointPort ...ports){
    this.ports.clear(); if (ports != null) {for (EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }
    public PortsNested<A> addNewPort(){
    return new PortsNestedImpl();
    }
    public PortsNested<A> addNewPortLike( EndpointPort item){
    return new PortsNestedImpl(item);
    }
    public A addNewPort( String name,  Integer port,  String protocol){
    return addToPorts(new EndpointPort(name, port, protocol));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointSubsetFluentImpl that = (EndpointSubsetFluentImpl) o;
if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
return true;

    }

    public class AddressesNestedImpl<N> extends EndpointAddressFluentImpl<AddressesNested<N>> implements AddressesNested<N>{

        private final EndpointAddressBuilder builder;
    
             AddressesNestedImpl (){
        this.builder = new EndpointAddressBuilder(this);
        }
             AddressesNestedImpl ( EndpointAddress item){
        this.builder = new EndpointAddressBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToAddresses(builder.build());
        }
            public N endAddresse(){
            return and();
        }
    
}
    public class NotReadyAddressesNestedImpl<N> extends EndpointAddressFluentImpl<NotReadyAddressesNested<N>> implements NotReadyAddressesNested<N>{

        private final EndpointAddressBuilder builder;
    
             NotReadyAddressesNestedImpl (){
        this.builder = new EndpointAddressBuilder(this);
        }
             NotReadyAddressesNestedImpl ( EndpointAddress item){
        this.builder = new EndpointAddressBuilder(this, item);
        }
    
            public N endNotReadyAddresse(){
            return and();
        }
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToNotReadyAddresses(builder.build());
        }
    
}
    public class PortsNestedImpl<N> extends EndpointPortFluentImpl<PortsNested<N>> implements PortsNested<N>{

        private final EndpointPortBuilder builder;
    
             PortsNestedImpl (){
        this.builder = new EndpointPortBuilder(this);
        }
             PortsNestedImpl ( EndpointPort item){
        this.builder = new EndpointPortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) EndpointSubsetFluentImpl.this.addToPorts(builder.build());
        }
    
}


}
