package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EndpointsFluent<A extends EndpointsFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public A addToSubsets( EndpointSubset ...items);    public A removeFromSubsets( EndpointSubset ...items);    public List<EndpointSubset> getSubsets();    public A withSubsets( List<EndpointSubset> subsets);    public A withSubsets( EndpointSubset ...subsets);    public SubsetsNested<A> addNewSubset();    public SubsetsNested<A> addNewSubsetLike( EndpointSubset item);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SubsetsNested<N> extends Nested<N>,EndpointSubsetFluent<SubsetsNested<N>>{
            public N and();            public N endSubset();        
}


}
