package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EndpointsFluentImpl<A extends EndpointsFluent<A>> extends BaseFluent<A> implements EndpointsFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<EndpointSubset, ?>> subsets = new ArrayList();
public EndpointsFluentImpl(){
    
}
public EndpointsFluentImpl( Endpoints instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSubsets(instance.getSubsets()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A addToSubsets( EndpointSubset ...items){
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.add(builder);this.subsets.add(builder);} return (A)this;
    }
    public A removeFromSubsets( EndpointSubset ...items){
    for (EndpointSubset item : items) {EndpointSubsetBuilder builder = new EndpointSubsetBuilder(item);_visitables.remove(builder);this.subsets.remove(builder);} return (A)this;
    }
    public List<EndpointSubset> getSubsets(){
    return build(subsets);
    }
    public A withSubsets( List<EndpointSubset> subsets){
    this.subsets.clear();if (subsets != null) {for (EndpointSubset item : subsets){this.addToSubsets(item);}} return (A) this;
    }
    public A withSubsets( EndpointSubset ...subsets){
    this.subsets.clear(); if (subsets != null) {for (EndpointSubset item :subsets){ this.addToSubsets(item);}} return (A) this;
    }
    public SubsetsNested<A> addNewSubset(){
    return new SubsetsNestedImpl();
    }
    public SubsetsNested<A> addNewSubsetLike( EndpointSubset item){
    return new SubsetsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EndpointsFluentImpl that = (EndpointsFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (subsets != null ? !subsets.equals(that.subsets) :that.subsets != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) EndpointsFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SubsetsNestedImpl<N> extends EndpointSubsetFluentImpl<SubsetsNested<N>> implements SubsetsNested<N>{

        private final EndpointSubsetBuilder builder;
    
             SubsetsNestedImpl (){
        this.builder = new EndpointSubsetBuilder(this);
        }
             SubsetsNestedImpl ( EndpointSubset item){
        this.builder = new EndpointSubsetBuilder(this, item);
        }
    
            public N and(){
            return (N) EndpointsFluentImpl.this.addToSubsets(builder.build());
        }
            public N endSubset(){
            return and();
        }
    
}


}
