package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EventBuilder extends EventFluentImpl<EventBuilder> implements VisitableBuilder<Event,EventBuilder>{

     EventFluent<?> fluent;
public EventBuilder(){
    this(new Event());
}
public EventBuilder( EventFluent<?> fluent ){
    this(fluent, new Event());
}
public EventBuilder( EventFluent<?> fluent , Event instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withCount(instance.getCount()); fluent.withFirstTimestamp(instance.getFirstTimestamp()); fluent.withInvolvedObject(instance.getInvolvedObject()); fluent.withKind(instance.getKind()); fluent.withLastTimestamp(instance.getLastTimestamp()); fluent.withMessage(instance.getMessage()); fluent.withMetadata(instance.getMetadata()); fluent.withReason(instance.getReason()); fluent.withSource(instance.getSource()); fluent.withType(instance.getType()); 
}
public EventBuilder( Event instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withCount(instance.getCount()); this.withFirstTimestamp(instance.getFirstTimestamp()); this.withInvolvedObject(instance.getInvolvedObject()); this.withKind(instance.getKind()); this.withLastTimestamp(instance.getLastTimestamp()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withSource(instance.getSource()); this.withType(instance.getType()); 
}

public Event build(){
    Event buildable = new Event(fluent.getApiVersion(),fluent.getCount(),fluent.getFirstTimestamp(),fluent.getInvolvedObject(),fluent.getKind(),fluent.getLastTimestamp(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getSource(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
EventBuilder that = (EventBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
