package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface EventFluent<A extends EventFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public Integer getCount();    public A withCount( Integer count);    public String getFirstTimestamp();    public A withFirstTimestamp( String firstTimestamp);    public ObjectReference getInvolvedObject();    public A withInvolvedObject( ObjectReference involvedObject);    public InvolvedObjectNested<A> withNewInvolvedObject();    public InvolvedObjectNested<A> withNewInvolvedObjectLike( ObjectReference item);    public InvolvedObjectNested<A> editInvolvedObject();    public String getKind();    public A withKind( String kind);    public String getLastTimestamp();    public A withLastTimestamp( String lastTimestamp);    public String getMessage();    public A withMessage( String message);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public String getReason();    public A withReason( String reason);    public EventSource getSource();    public A withSource( EventSource source);    public SourceNested<A> withNewSource();    public SourceNested<A> withNewSourceLike( EventSource item);    public SourceNested<A> editSource();    public A withNewSource( String component,  String host);    public String getType();    public A withType( String type);
    public interface InvolvedObjectNested<N> extends Nested<N>,ObjectReferenceFluent<InvolvedObjectNested<N>>{
            public N and();            public N endInvolvedObject();        
}

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SourceNested<N> extends Nested<N>,EventSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}


}
