package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class EventFluentImpl<A extends EventFluent<A>> extends BaseFluent<A> implements EventFluent<A>{

     String apiVersion;     Integer count;     String firstTimestamp;     VisitableBuilder<ObjectReference, ?> involvedObject;     String kind;     String lastTimestamp;     String message;     VisitableBuilder<ObjectMeta, ?> metadata;     String reason;     VisitableBuilder<EventSource, ?> source;     String type;
public EventFluentImpl(){
    
}
public EventFluentImpl( Event instance ){
    this.withApiVersion(instance.getApiVersion()); this.withCount(instance.getCount()); this.withFirstTimestamp(instance.getFirstTimestamp()); this.withInvolvedObject(instance.getInvolvedObject()); this.withKind(instance.getKind()); this.withLastTimestamp(instance.getLastTimestamp()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withSource(instance.getSource()); this.withType(instance.getType()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public Integer getCount(){
    return this.count;
    }
    public A withCount( Integer count){
    this.count=count; return (A) this;
    }
    public String getFirstTimestamp(){
    return this.firstTimestamp;
    }
    public A withFirstTimestamp( String firstTimestamp){
    this.firstTimestamp=firstTimestamp; return (A) this;
    }
    public ObjectReference getInvolvedObject(){
    return this.involvedObject!=null?this.involvedObject.build():null;
    }
    public A withInvolvedObject( ObjectReference involvedObject){
    if (involvedObject!=null){ this.involvedObject= new ObjectReferenceBuilder(involvedObject); _visitables.add(this.involvedObject);} return (A) this;
    }
    public InvolvedObjectNested<A> withNewInvolvedObject(){
    return new InvolvedObjectNestedImpl();
    }
    public InvolvedObjectNested<A> withNewInvolvedObjectLike( ObjectReference item){
    return new InvolvedObjectNestedImpl(item);
    }
    public InvolvedObjectNested<A> editInvolvedObject(){
    return withNewInvolvedObjectLike(getInvolvedObject());
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getLastTimestamp(){
    return this.lastTimestamp;
    }
    public A withLastTimestamp( String lastTimestamp){
    this.lastTimestamp=lastTimestamp; return (A) this;
    }
    public String getMessage(){
    return this.message;
    }
    public A withMessage( String message){
    this.message=message; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getReason(){
    return this.reason;
    }
    public A withReason( String reason){
    this.reason=reason; return (A) this;
    }
    public EventSource getSource(){
    return this.source!=null?this.source.build():null;
    }
    public A withSource( EventSource source){
    if (source!=null){ this.source= new EventSourceBuilder(source); _visitables.add(this.source);} return (A) this;
    }
    public SourceNested<A> withNewSource(){
    return new SourceNestedImpl();
    }
    public SourceNested<A> withNewSourceLike( EventSource item){
    return new SourceNestedImpl(item);
    }
    public SourceNested<A> editSource(){
    return withNewSourceLike(getSource());
    }
    public A withNewSource( String component,  String host){
    return withSource(new EventSource(component, host));
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EventFluentImpl that = (EventFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (count != null ? !count.equals(that.count) :that.count != null) return false;
if (firstTimestamp != null ? !firstTimestamp.equals(that.firstTimestamp) :that.firstTimestamp != null) return false;
if (involvedObject != null ? !involvedObject.equals(that.involvedObject) :that.involvedObject != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (lastTimestamp != null ? !lastTimestamp.equals(that.lastTimestamp) :that.lastTimestamp != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (source != null ? !source.equals(that.source) :that.source != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }

    public class InvolvedObjectNestedImpl<N> extends ObjectReferenceFluentImpl<InvolvedObjectNested<N>> implements InvolvedObjectNested<N>{

        private final ObjectReferenceBuilder builder;
    
             InvolvedObjectNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             InvolvedObjectNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withInvolvedObject(builder.build());
        }
            public N endInvolvedObject(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SourceNestedImpl<N> extends EventSourceFluentImpl<SourceNested<N>> implements SourceNested<N>{

        private final EventSourceBuilder builder;
    
             SourceNestedImpl ( EventSource item){
        this.builder = new EventSourceBuilder(this, item);
        }
             SourceNestedImpl (){
        this.builder = new EventSourceBuilder(this);
        }
    
            public N and(){
            return (N) EventFluentImpl.this.withSource(builder.build());
        }
            public N endSource(){
            return and();
        }
    
}


}
