package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class FCVolumeSourceBuilder extends FCVolumeSourceFluentImpl<FCVolumeSourceBuilder> implements VisitableBuilder<FCVolumeSource,FCVolumeSourceBuilder>{

     FCVolumeSourceFluent<?> fluent;
public FCVolumeSourceBuilder(){
    this(new FCVolumeSource());
}
public FCVolumeSourceBuilder( FCVolumeSourceFluent<?> fluent ){
    this(fluent, new FCVolumeSource());
}
public FCVolumeSourceBuilder( FCVolumeSourceFluent<?> fluent , FCVolumeSource instance ){
    this.fluent = fluent; fluent.withFsType(instance.getFsType()); fluent.withLun(instance.getLun()); fluent.withReadOnly(instance.getReadOnly()); fluent.withTargetWWNs(instance.getTargetWWNs()); 
}
public FCVolumeSourceBuilder( FCVolumeSource instance ){
    this.fluent = this; this.withFsType(instance.getFsType()); this.withLun(instance.getLun()); this.withReadOnly(instance.getReadOnly()); this.withTargetWWNs(instance.getTargetWWNs()); 
}

public FCVolumeSource build(){
    FCVolumeSource buildable = new FCVolumeSource(fluent.getFsType(),fluent.getLun(),fluent.isReadOnly(),fluent.getTargetWWNs());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
FCVolumeSourceBuilder that = (FCVolumeSourceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
