package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class HTTPHeaderBuilder extends HTTPHeaderFluentImpl<HTTPHeaderBuilder> implements VisitableBuilder<HTTPHeader,HTTPHeaderBuilder>{

     HTTPHeaderFluent<?> fluent;
public HTTPHeaderBuilder(){
    this(new HTTPHeader());
}
public HTTPHeaderBuilder( HTTPHeaderFluent<?> fluent ){
    this(fluent, new HTTPHeader());
}
public HTTPHeaderBuilder( HTTPHeaderFluent<?> fluent , HTTPHeader instance ){
    this.fluent = fluent; fluent.withName(instance.getName()); fluent.withValue(instance.getValue()); 
}
public HTTPHeaderBuilder( HTTPHeader instance ){
    this.fluent = this; this.withName(instance.getName()); this.withValue(instance.getValue()); 
}

public HTTPHeader build(){
    HTTPHeader buildable = new HTTPHeader(fluent.getName(),fluent.getValue());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HTTPHeaderBuilder that = (HTTPHeaderBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
