package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class LimitRangeFluentImpl<A extends LimitRangeFluent<A>> extends BaseFluent<A> implements LimitRangeFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<LimitRangeSpec, ?> spec;
public LimitRangeFluentImpl(){
    
}
public LimitRangeFluentImpl( LimitRange instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public LimitRangeSpec getSpec(){
    return this.spec!=null?this.spec.build():null;
    }
    public A withSpec( LimitRangeSpec spec){
    if (spec!=null){ this.spec= new LimitRangeSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }
    public SpecNested<A> withNewSpec(){
    return new SpecNestedImpl();
    }
    public SpecNested<A> withNewSpecLike( LimitRangeSpec item){
    return new SpecNestedImpl(item);
    }
    public SpecNested<A> editSpec(){
    return withNewSpecLike(getSpec());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LimitRangeFluentImpl that = (LimitRangeFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) LimitRangeFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class SpecNestedImpl<N> extends LimitRangeSpecFluentImpl<SpecNested<N>> implements SpecNested<N>{

        private final LimitRangeSpecBuilder builder;
    
             SpecNestedImpl (){
        this.builder = new LimitRangeSpecBuilder(this);
        }
             SpecNestedImpl ( LimitRangeSpec item){
        this.builder = new LimitRangeSpecBuilder(this, item);
        }
    
            public N endSpec(){
            return and();
        }
            public N and(){
            return (N) LimitRangeFluentImpl.this.withSpec(builder.build());
        }
    
}


}
