package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedClusterFluentImpl<A extends NamedClusterFluent<A>> extends BaseFluent<A> implements NamedClusterFluent<A>{

     VisitableBuilder<Cluster, ?> cluster;     String name;
public NamedClusterFluentImpl(){
    
}
public NamedClusterFluentImpl( NamedCluster instance ){
    this.withCluster(instance.getCluster()); this.withName(instance.getName()); 
}

    public Cluster getCluster(){
    return this.cluster!=null?this.cluster.build():null;
    }
    public A withCluster( Cluster cluster){
    if (cluster!=null){ this.cluster= new ClusterBuilder(cluster); _visitables.add(this.cluster);} return (A) this;
    }
    public ClusterNested<A> withNewCluster(){
    return new ClusterNestedImpl();
    }
    public ClusterNested<A> withNewClusterLike( Cluster item){
    return new ClusterNestedImpl(item);
    }
    public ClusterNested<A> editCluster(){
    return withNewClusterLike(getCluster());
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterFluentImpl that = (NamedClusterFluentImpl) o;
if (cluster != null ? !cluster.equals(that.cluster) :that.cluster != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
return true;

    }

    public class ClusterNestedImpl<N> extends ClusterFluentImpl<ClusterNested<N>> implements ClusterNested<N>{

        private final ClusterBuilder builder;
    
             ClusterNestedImpl (){
        this.builder = new ClusterBuilder(this);
        }
             ClusterNestedImpl ( Cluster item){
        this.builder = new ClusterBuilder(this, item);
        }
    
            public N endCluster(){
            return and();
        }
            public N and(){
            return (N) NamedClusterFluentImpl.this.withCluster(builder.build());
        }
    
}


}
