package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface NamespaceFluent<A extends NamespaceFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public NamespaceSpec getSpec();    public A withSpec( NamespaceSpec spec);    public SpecNested<A> withNewSpec();    public SpecNested<A> withNewSpecLike( NamespaceSpec item);    public SpecNested<A> editSpec();    public NamespaceStatus getStatus();    public A withStatus( NamespaceStatus status);    public StatusNested<A> withNewStatus();    public StatusNested<A> withNewStatusLike( NamespaceStatus item);    public StatusNested<A> editStatus();    public A withNewStatus( String phase);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>,NamespaceSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>,NamespaceStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
