package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NodeConditionFluentImpl<A extends NodeConditionFluent<A>> extends BaseFluent<A> implements NodeConditionFluent<A>{

     String lastHeartbeatTime;     String lastTransitionTime;     String message;     String reason;     String status;     String type;
public NodeConditionFluentImpl(){
    
}
public NodeConditionFluentImpl( NodeCondition instance ){
    this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); this.withLastTransitionTime(instance.getLastTransitionTime()); this.withMessage(instance.getMessage()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

    public String getLastHeartbeatTime(){
    return this.lastHeartbeatTime;
    }
    public A withLastHeartbeatTime( String lastHeartbeatTime){
    this.lastHeartbeatTime=lastHeartbeatTime; return (A) this;
    }
    public String getLastTransitionTime(){
    return this.lastTransitionTime;
    }
    public A withLastTransitionTime( String lastTransitionTime){
    this.lastTransitionTime=lastTransitionTime; return (A) this;
    }
    public String getMessage(){
    return this.message;
    }
    public A withMessage( String message){
    this.message=message; return (A) this;
    }
    public String getReason(){
    return this.reason;
    }
    public A withReason( String reason){
    this.reason=reason; return (A) this;
    }
    public String getStatus(){
    return this.status;
    }
    public A withStatus( String status){
    this.status=status; return (A) this;
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeConditionFluentImpl that = (NodeConditionFluentImpl) o;
if (lastHeartbeatTime != null ? !lastHeartbeatTime.equals(that.lastHeartbeatTime) :that.lastHeartbeatTime != null) return false;
if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }



}
