package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NodeSpecFluentImpl<A extends NodeSpecFluent<A>> extends BaseFluent<A> implements NodeSpecFluent<A>{

     String externalID;     String podCIDR;     String providerID;     Boolean unschedulable;
public NodeSpecFluentImpl(){
    
}
public NodeSpecFluentImpl( NodeSpec instance ){
    this.withExternalID(instance.getExternalID()); this.withPodCIDR(instance.getPodCIDR()); this.withProviderID(instance.getProviderID()); this.withUnschedulable(instance.getUnschedulable()); 
}

    public String getExternalID(){
    return this.externalID;
    }
    public A withExternalID( String externalID){
    this.externalID=externalID; return (A) this;
    }
    public String getPodCIDR(){
    return this.podCIDR;
    }
    public A withPodCIDR( String podCIDR){
    this.podCIDR=podCIDR; return (A) this;
    }
    public String getProviderID(){
    return this.providerID;
    }
    public A withProviderID( String providerID){
    this.providerID=providerID; return (A) this;
    }
    public Boolean isUnschedulable(){
    return this.unschedulable;
    }
    public A withUnschedulable( Boolean unschedulable){
    this.unschedulable=unschedulable; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeSpecFluentImpl that = (NodeSpecFluentImpl) o;
if (externalID != null ? !externalID.equals(that.externalID) :that.externalID != null) return false;
if (podCIDR != null ? !podCIDR.equals(that.podCIDR) :that.podCIDR != null) return false;
if (providerID != null ? !providerID.equals(that.providerID) :that.providerID != null) return false;
if (unschedulable != null ? !unschedulable.equals(that.unschedulable) :that.unschedulable != null) return false;
return true;

    }



}
