package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class NodeSystemInfoFluentImpl<A extends NodeSystemInfoFluent<A>> extends BaseFluent<A> implements NodeSystemInfoFluent<A>{

     String bootID;     String containerRuntimeVersion;     String kernelVersion;     String kubeProxyVersion;     String kubeletVersion;     String machineID;     String osImage;     String systemUUID;
public NodeSystemInfoFluentImpl(){
    
}
public NodeSystemInfoFluentImpl( NodeSystemInfo instance ){
    this.withBootID(instance.getBootID()); this.withContainerRuntimeVersion(instance.getContainerRuntimeVersion()); this.withKernelVersion(instance.getKernelVersion()); this.withKubeProxyVersion(instance.getKubeProxyVersion()); this.withKubeletVersion(instance.getKubeletVersion()); this.withMachineID(instance.getMachineID()); this.withOsImage(instance.getOsImage()); this.withSystemUUID(instance.getSystemUUID()); 
}

    public String getBootID(){
    return this.bootID;
    }
    public A withBootID( String bootID){
    this.bootID=bootID; return (A) this;
    }
    public String getContainerRuntimeVersion(){
    return this.containerRuntimeVersion;
    }
    public A withContainerRuntimeVersion( String containerRuntimeVersion){
    this.containerRuntimeVersion=containerRuntimeVersion; return (A) this;
    }
    public String getKernelVersion(){
    return this.kernelVersion;
    }
    public A withKernelVersion( String kernelVersion){
    this.kernelVersion=kernelVersion; return (A) this;
    }
    public String getKubeProxyVersion(){
    return this.kubeProxyVersion;
    }
    public A withKubeProxyVersion( String kubeProxyVersion){
    this.kubeProxyVersion=kubeProxyVersion; return (A) this;
    }
    public String getKubeletVersion(){
    return this.kubeletVersion;
    }
    public A withKubeletVersion( String kubeletVersion){
    this.kubeletVersion=kubeletVersion; return (A) this;
    }
    public String getMachineID(){
    return this.machineID;
    }
    public A withMachineID( String machineID){
    this.machineID=machineID; return (A) this;
    }
    public String getOsImage(){
    return this.osImage;
    }
    public A withOsImage( String osImage){
    this.osImage=osImage; return (A) this;
    }
    public String getSystemUUID(){
    return this.systemUUID;
    }
    public A withSystemUUID( String systemUUID){
    this.systemUUID=systemUUID; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NodeSystemInfoFluentImpl that = (NodeSystemInfoFluentImpl) o;
if (bootID != null ? !bootID.equals(that.bootID) :that.bootID != null) return false;
if (containerRuntimeVersion != null ? !containerRuntimeVersion.equals(that.containerRuntimeVersion) :that.containerRuntimeVersion != null) return false;
if (kernelVersion != null ? !kernelVersion.equals(that.kernelVersion) :that.kernelVersion != null) return false;
if (kubeProxyVersion != null ? !kubeProxyVersion.equals(that.kubeProxyVersion) :that.kubeProxyVersion != null) return false;
if (kubeletVersion != null ? !kubeletVersion.equals(that.kubeletVersion) :that.kubeletVersion != null) return false;
if (machineID != null ? !machineID.equals(that.machineID) :that.machineID != null) return false;
if (osImage != null ? !osImage.equals(that.osImage) :that.osImage != null) return false;
if (systemUUID != null ? !systemUUID.equals(that.systemUUID) :that.systemUUID != null) return false;
return true;

    }



}
