package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ObjectReferenceFluentImpl<A extends ObjectReferenceFluent<A>> extends BaseFluent<A> implements ObjectReferenceFluent<A>{

     String apiVersion;     String fieldPath;     String kind;     String name;     String namespace;     String resourceVersion;     String uid;
public ObjectReferenceFluentImpl(){
    
}
public ObjectReferenceFluentImpl( ObjectReference instance ){
    this.withApiVersion(instance.getApiVersion()); this.withFieldPath(instance.getFieldPath()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withNamespace(instance.getNamespace()); this.withResourceVersion(instance.getResourceVersion()); this.withUid(instance.getUid()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getFieldPath(){
    return this.fieldPath;
    }
    public A withFieldPath( String fieldPath){
    this.fieldPath=fieldPath; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public String getName(){
    return this.name;
    }
    public A withName( String name){
    this.name=name; return (A) this;
    }
    public String getNamespace(){
    return this.namespace;
    }
    public A withNamespace( String namespace){
    this.namespace=namespace; return (A) this;
    }
    public String getResourceVersion(){
    return this.resourceVersion;
    }
    public A withResourceVersion( String resourceVersion){
    this.resourceVersion=resourceVersion; return (A) this;
    }
    public String getUid(){
    return this.uid;
    }
    public A withUid( String uid){
    this.uid=uid; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ObjectReferenceFluentImpl that = (ObjectReferenceFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (fieldPath != null ? !fieldPath.equals(that.fieldPath) :that.fieldPath != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
if (resourceVersion != null ? !resourceVersion.equals(that.resourceVersion) :that.resourceVersion != null) return false;
if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
return true;

    }



}
