package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeClaimSpecFluent<A>{

     List<String> accessModes = new ArrayList();     VisitableBuilder<ResourceRequirements, ?> resources;     String volumeName;
public PersistentVolumeClaimSpecFluentImpl(){
    
}
public PersistentVolumeClaimSpecFluentImpl( PersistentVolumeClaimSpec instance ){
    this.withAccessModes(instance.getAccessModes()); this.withResources(instance.getResources()); this.withVolumeName(instance.getVolumeName()); 
}

    public A addToAccessModes( String ...items){
    for (String item : items) {this.accessModes.add(item);} return (A)this;
    }
    public A removeFromAccessModes( String ...items){
    for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }
    public List<String> getAccessModes(){
    return this.accessModes;
    }
    public A withAccessModes( List<String> accessModes){
    this.accessModes.clear();if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (A) this;
    }
    public A withAccessModes( String ...accessModes){
    this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }
    public ResourceRequirements getResources(){
    return this.resources!=null?this.resources.build():null;
    }
    public A withResources( ResourceRequirements resources){
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.add(this.resources);} return (A) this;
    }
    public ResourcesNested<A> withNewResources(){
    return new ResourcesNestedImpl();
    }
    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item){
    return new ResourcesNestedImpl(item);
    }
    public ResourcesNested<A> editResources(){
    return withNewResourcesLike(getResources());
    }
    public String getVolumeName(){
    return this.volumeName;
    }
    public A withVolumeName( String volumeName){
    this.volumeName=volumeName; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl) o;
if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
return true;

    }

    public class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<ResourcesNested<N>> implements ResourcesNested<N>{

        private final ResourceRequirementsBuilder builder;
    
             ResourcesNestedImpl (){
        this.builder = new ResourceRequirementsBuilder(this);
        }
             ResourcesNestedImpl ( ResourceRequirements item){
        this.builder = new ResourceRequirementsBuilder(this, item);
        }
    
            public N and(){
            return (N) PersistentVolumeClaimSpecFluentImpl.this.withResources(builder.build());
        }
            public N endResources(){
            return and();
        }
    
}


}
