package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface PersistentVolumeSpecFluent<A extends PersistentVolumeSpecFluent<A>> extends Fluent<A>{


    public A addToAccessModes( String ...items);    public A removeFromAccessModes( String ...items);    public List<String> getAccessModes();    public A withAccessModes( List<String> accessModes);    public A withAccessModes( String ...accessModes);    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();    public A withAwsElasticBlockStore( AWSElasticBlockStoreVolumeSource awsElasticBlockStore);    public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();    public AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike( AWSElasticBlockStoreVolumeSource item);    public AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();    public A withNewAwsElasticBlockStore( String fsType,  Integer partition,  Boolean readOnly,  String volumeID);    public AzureFileVolumeSource getAzureFile();    public A withAzureFile( AzureFileVolumeSource azureFile);    public AzureFileNested<A> withNewAzureFile();    public AzureFileNested<A> withNewAzureFileLike( AzureFileVolumeSource item);    public AzureFileNested<A> editAzureFile();    public A withNewAzureFile( Boolean readOnly,  String secretName,  String shareName);    public A addToCapacity( String key,  Quantity value);    public A addToCapacity( Map<String, Quantity> map);    public A removeFromCapacity( String key);    public A removeFromCapacity( Map<String, Quantity> map);    public Map<String, Quantity> getCapacity();    public A withCapacity( Map<String, Quantity> capacity);    public CephFSVolumeSource getCephfs();    public A withCephfs( CephFSVolumeSource cephfs);    public CephfsNested<A> withNewCephfs();    public CephfsNested<A> withNewCephfsLike( CephFSVolumeSource item);    public CephfsNested<A> editCephfs();    public CinderVolumeSource getCinder();    public A withCinder( CinderVolumeSource cinder);    public CinderNested<A> withNewCinder();    public CinderNested<A> withNewCinderLike( CinderVolumeSource item);    public CinderNested<A> editCinder();    public A withNewCinder( String fsType,  Boolean readOnly,  String volumeID);    public ObjectReference getClaimRef();    public A withClaimRef( ObjectReference claimRef);    public ClaimRefNested<A> withNewClaimRef();    public ClaimRefNested<A> withNewClaimRefLike( ObjectReference item);    public ClaimRefNested<A> editClaimRef();    public FCVolumeSource getFc();    public A withFc( FCVolumeSource fc);    public FcNested<A> withNewFc();    public FcNested<A> withNewFcLike( FCVolumeSource item);    public FcNested<A> editFc();    public FlexVolumeSource getFlexVolume();    public A withFlexVolume( FlexVolumeSource flexVolume);    public FlexVolumeNested<A> withNewFlexVolume();    public FlexVolumeNested<A> withNewFlexVolumeLike( FlexVolumeSource item);    public FlexVolumeNested<A> editFlexVolume();    public FlockerVolumeSource getFlocker();    public A withFlocker( FlockerVolumeSource flocker);    public FlockerNested<A> withNewFlocker();    public FlockerNested<A> withNewFlockerLike( FlockerVolumeSource item);    public FlockerNested<A> editFlocker();    public A withNewFlocker( String datasetName);    public GCEPersistentDiskVolumeSource getGcePersistentDisk();    public A withGcePersistentDisk( GCEPersistentDiskVolumeSource gcePersistentDisk);    public GcePersistentDiskNested<A> withNewGcePersistentDisk();    public GcePersistentDiskNested<A> withNewGcePersistentDiskLike( GCEPersistentDiskVolumeSource item);    public GcePersistentDiskNested<A> editGcePersistentDisk();    public A withNewGcePersistentDisk( String fsType,  Integer partition,  String pdName,  Boolean readOnly);    public GlusterfsVolumeSource getGlusterfs();    public A withGlusterfs( GlusterfsVolumeSource glusterfs);    public GlusterfsNested<A> withNewGlusterfs();    public GlusterfsNested<A> withNewGlusterfsLike( GlusterfsVolumeSource item);    public GlusterfsNested<A> editGlusterfs();    public A withNewGlusterfs( String endpoints,  String path,  Boolean readOnly);    public HostPathVolumeSource getHostPath();    public A withHostPath( HostPathVolumeSource hostPath);    public HostPathNested<A> withNewHostPath();    public HostPathNested<A> withNewHostPathLike( HostPathVolumeSource item);    public HostPathNested<A> editHostPath();    public A withNewHostPath( String path);    public ISCSIVolumeSource getIscsi();    public A withIscsi( ISCSIVolumeSource iscsi);    public IscsiNested<A> withNewIscsi();    public IscsiNested<A> withNewIscsiLike( ISCSIVolumeSource item);    public IscsiNested<A> editIscsi();    public NFSVolumeSource getNfs();    public A withNfs( NFSVolumeSource nfs);    public NfsNested<A> withNewNfs();    public NfsNested<A> withNewNfsLike( NFSVolumeSource item);    public NfsNested<A> editNfs();    public A withNewNfs( String path,  Boolean readOnly,  String server);    public String getPersistentVolumeReclaimPolicy();    public A withPersistentVolumeReclaimPolicy( String persistentVolumeReclaimPolicy);    public RBDVolumeSource getRbd();    public A withRbd( RBDVolumeSource rbd);    public RbdNested<A> withNewRbd();    public RbdNested<A> withNewRbdLike( RBDVolumeSource item);    public RbdNested<A> editRbd();
    public interface AwsElasticBlockStoreNested<N> extends Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<AwsElasticBlockStoreNested<N>>{
            public N endAwsElasticBlockStore();            public N and();        
}

    public interface AzureFileNested<N> extends Nested<N>,AzureFileVolumeSourceFluent<AzureFileNested<N>>{
            public N endAzureFile();            public N and();        
}

    public interface CephfsNested<N> extends Nested<N>,CephFSVolumeSourceFluent<CephfsNested<N>>{
            public N endCephfs();            public N and();        
}

    public interface CinderNested<N> extends Nested<N>,CinderVolumeSourceFluent<CinderNested<N>>{
            public N and();            public N endCinder();        
}

    public interface ClaimRefNested<N> extends Nested<N>,ObjectReferenceFluent<ClaimRefNested<N>>{
            public N and();            public N endClaimRef();        
}

    public interface FcNested<N> extends Nested<N>,FCVolumeSourceFluent<FcNested<N>>{
            public N and();            public N endFc();        
}

    public interface FlexVolumeNested<N> extends Nested<N>,FlexVolumeSourceFluent<FlexVolumeNested<N>>{
            public N and();            public N endFlexVolume();        
}

    public interface FlockerNested<N> extends Nested<N>,FlockerVolumeSourceFluent<FlockerNested<N>>{
            public N and();            public N endFlocker();        
}

    public interface GcePersistentDiskNested<N> extends Nested<N>,GCEPersistentDiskVolumeSourceFluent<GcePersistentDiskNested<N>>{
            public N endGcePersistentDisk();            public N and();        
}

    public interface GlusterfsNested<N> extends Nested<N>,GlusterfsVolumeSourceFluent<GlusterfsNested<N>>{
            public N and();            public N endGlusterfs();        
}

    public interface HostPathNested<N> extends Nested<N>,HostPathVolumeSourceFluent<HostPathNested<N>>{
            public N and();            public N endHostPath();        
}

    public interface IscsiNested<N> extends Nested<N>,ISCSIVolumeSourceFluent<IscsiNested<N>>{
            public N and();            public N endIscsi();        
}

    public interface NfsNested<N> extends Nested<N>,NFSVolumeSourceFluent<NfsNested<N>>{
            public N endNfs();            public N and();        
}

    public interface RbdNested<N> extends Nested<N>,RBDVolumeSourceFluent<RbdNested<N>>{
            public N and();            public N endRbd();        
}


}
