package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;

public class PodStatusFluentImpl<A extends PodStatusFluent<A>> extends BaseFluent<A> implements PodStatusFluent<A>{

     List<VisitableBuilder<PodCondition, ?>> conditions = new ArrayList();     List<VisitableBuilder<ContainerStatus, ?>> containerStatuses = new ArrayList();     String hostIP;     String message;     String phase;     String podIP;     String reason;     String startTime;
public PodStatusFluentImpl(){
    
}
public PodStatusFluentImpl( PodStatus instance ){
    this.withConditions(instance.getConditions()); this.withContainerStatuses(instance.getContainerStatuses()); this.withHostIP(instance.getHostIP()); this.withMessage(instance.getMessage()); this.withPhase(instance.getPhase()); this.withPodIP(instance.getPodIP()); this.withReason(instance.getReason()); this.withStartTime(instance.getStartTime()); 
}

    public A addToConditions( PodCondition ...items){
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.add(builder);this.conditions.add(builder);} return (A)this;
    }
    public A removeFromConditions( PodCondition ...items){
    for (PodCondition item : items) {PodConditionBuilder builder = new PodConditionBuilder(item);_visitables.remove(builder);this.conditions.remove(builder);} return (A)this;
    }
    public List<PodCondition> getConditions(){
    return build(conditions);
    }
    public A withConditions( List<PodCondition> conditions){
    this.conditions.clear();if (conditions != null) {for (PodCondition item : conditions){this.addToConditions(item);}} return (A) this;
    }
    public A withConditions( PodCondition ...conditions){
    this.conditions.clear(); if (conditions != null) {for (PodCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }
    public ConditionsNested<A> addNewCondition(){
    return new ConditionsNestedImpl();
    }
    public ConditionsNested<A> addNewConditionLike( PodCondition item){
    return new ConditionsNestedImpl(item);
    }
    public A addToContainerStatuses( ContainerStatus ...items){
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.add(builder);this.containerStatuses.add(builder);} return (A)this;
    }
    public A removeFromContainerStatuses( ContainerStatus ...items){
    for (ContainerStatus item : items) {ContainerStatusBuilder builder = new ContainerStatusBuilder(item);_visitables.remove(builder);this.containerStatuses.remove(builder);} return (A)this;
    }
    public List<ContainerStatus> getContainerStatuses(){
    return build(containerStatuses);
    }
    public A withContainerStatuses( List<ContainerStatus> containerStatuses){
    this.containerStatuses.clear();if (containerStatuses != null) {for (ContainerStatus item : containerStatuses){this.addToContainerStatuses(item);}} return (A) this;
    }
    public A withContainerStatuses( ContainerStatus ...containerStatuses){
    this.containerStatuses.clear(); if (containerStatuses != null) {for (ContainerStatus item :containerStatuses){ this.addToContainerStatuses(item);}} return (A) this;
    }
    public ContainerStatusesNested<A> addNewContainerStatuse(){
    return new ContainerStatusesNestedImpl();
    }
    public ContainerStatusesNested<A> addNewContainerStatuseLike( ContainerStatus item){
    return new ContainerStatusesNestedImpl(item);
    }
    public String getHostIP(){
    return this.hostIP;
    }
    public A withHostIP( String hostIP){
    this.hostIP=hostIP; return (A) this;
    }
    public String getMessage(){
    return this.message;
    }
    public A withMessage( String message){
    this.message=message; return (A) this;
    }
    public String getPhase(){
    return this.phase;
    }
    public A withPhase( String phase){
    this.phase=phase; return (A) this;
    }
    public String getPodIP(){
    return this.podIP;
    }
    public A withPodIP( String podIP){
    this.podIP=podIP; return (A) this;
    }
    public String getReason(){
    return this.reason;
    }
    public A withReason( String reason){
    this.reason=reason; return (A) this;
    }
    public String getStartTime(){
    return this.startTime;
    }
    public A withStartTime( String startTime){
    this.startTime=startTime; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodStatusFluentImpl that = (PodStatusFluentImpl) o;
if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
if (containerStatuses != null ? !containerStatuses.equals(that.containerStatuses) :that.containerStatuses != null) return false;
if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
if (podIP != null ? !podIP.equals(that.podIP) :that.podIP != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
return true;

    }

    public class ConditionsNestedImpl<N> extends PodConditionFluentImpl<ConditionsNested<N>> implements ConditionsNested<N>{

        private final PodConditionBuilder builder;
    
             ConditionsNestedImpl (){
        this.builder = new PodConditionBuilder(this);
        }
             ConditionsNestedImpl ( PodCondition item){
        this.builder = new PodConditionBuilder(this, item);
        }
    
            public N endCondition(){
            return and();
        }
            public N and(){
            return (N) PodStatusFluentImpl.this.addToConditions(builder.build());
        }
    
}
    public class ContainerStatusesNestedImpl<N> extends ContainerStatusFluentImpl<ContainerStatusesNested<N>> implements ContainerStatusesNested<N>{

        private final ContainerStatusBuilder builder;
    
             ContainerStatusesNestedImpl (){
        this.builder = new ContainerStatusBuilder(this);
        }
             ContainerStatusesNestedImpl ( ContainerStatus item){
        this.builder = new ContainerStatusBuilder(this, item);
        }
    
            public N endContainerStatuse(){
            return and();
        }
            public N and(){
            return (N) PodStatusFluentImpl.this.addToContainerStatuses(builder.build());
        }
    
}


}
