package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class PodTemplateFluentImpl<A extends PodTemplateFluent<A>> extends BaseFluent<A> implements PodTemplateFluent<A>{

     String apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     VisitableBuilder<PodTemplateSpec, ?> template;
public PodTemplateFluentImpl(){
    
}
public PodTemplateFluentImpl( PodTemplate instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withTemplate(instance.getTemplate()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public A withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }
    public TemplateNested<A> withNewTemplate(){
    return new TemplateNestedImpl();
    }
    public TemplateNested<A> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl(item);
    }
    public TemplateNested<A> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PodTemplateFluentImpl that = (PodTemplateFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) PodTemplateFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) PodTemplateFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
