package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import java.util.List;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class PreferencesFluentImpl<A extends PreferencesFluent<A>> extends BaseFluent<A> implements PreferencesFluent<A>{

     Boolean colors;     List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
public PreferencesFluentImpl(){
    
}
public PreferencesFluentImpl( Preferences instance ){
    this.withColors(instance.getColors()); this.withExtensions(instance.getExtensions()); 
}

    public Boolean isColors(){
    return this.colors;
    }
    public A withColors( Boolean colors){
    this.colors=colors; return (A) this;
    }
    public A addToExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }
    public A removeFromExtensions( NamedExtension ...items){
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }
    public List<NamedExtension> getExtensions(){
    return build(extensions);
    }
    public A withExtensions( List<NamedExtension> extensions){
    this.extensions.clear();if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }
    public A withExtensions( NamedExtension ...extensions){
    this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }
    public ExtensionsNested<A> addNewExtension(){
    return new ExtensionsNestedImpl();
    }
    public ExtensionsNested<A> addNewExtensionLike( NamedExtension item){
    return new ExtensionsNestedImpl(item);
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
PreferencesFluentImpl that = (PreferencesFluentImpl) o;
if (colors != null ? !colors.equals(that.colors) :that.colors != null) return false;
if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
return true;

    }

    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ExtensionsNested<N>> implements ExtensionsNested<N>{

        private final NamedExtensionBuilder builder;
    
             ExtensionsNestedImpl (){
        this.builder = new NamedExtensionBuilder(this);
        }
             ExtensionsNestedImpl ( NamedExtension item){
        this.builder = new NamedExtensionBuilder(this, item);
        }
    
            public N and(){
            return (N) PreferencesFluentImpl.this.addToExtensions(builder.build());
        }
            public N endExtension(){
            return and();
        }
    
}


}
