package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class RBDVolumeSourceFluentImpl<A extends RBDVolumeSourceFluent<A>> extends BaseFluent<A> implements RBDVolumeSourceFluent<A>{

     String fsType;     String image;     String keyring;     List<String> monitors = new ArrayList();     String pool;     Boolean readOnly;     VisitableBuilder<LocalObjectReference, ?> secretRef;     String user;
public RBDVolumeSourceFluentImpl(){
    
}
public RBDVolumeSourceFluentImpl( RBDVolumeSource instance ){
    this.withFsType(instance.getFsType()); this.withImage(instance.getImage()); this.withKeyring(instance.getKeyring()); this.withMonitors(instance.getMonitors()); this.withPool(instance.getPool()); this.withReadOnly(instance.getReadOnly()); this.withSecretRef(instance.getSecretRef()); this.withUser(instance.getUser()); 
}

    public String getFsType(){
    return this.fsType;
    }
    public A withFsType( String fsType){
    this.fsType=fsType; return (A) this;
    }
    public String getImage(){
    return this.image;
    }
    public A withImage( String image){
    this.image=image; return (A) this;
    }
    public String getKeyring(){
    return this.keyring;
    }
    public A withKeyring( String keyring){
    this.keyring=keyring; return (A) this;
    }
    public A addToMonitors( String ...items){
    for (String item : items) {this.monitors.add(item);} return (A)this;
    }
    public A removeFromMonitors( String ...items){
    for (String item : items) {this.monitors.remove(item);} return (A)this;
    }
    public List<String> getMonitors(){
    return this.monitors;
    }
    public A withMonitors( List<String> monitors){
    this.monitors.clear();if (monitors != null) {for (String item : monitors){this.addToMonitors(item);}} return (A) this;
    }
    public A withMonitors( String ...monitors){
    this.monitors.clear(); if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }
    public String getPool(){
    return this.pool;
    }
    public A withPool( String pool){
    this.pool=pool; return (A) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public A withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (A) this;
    }
    public LocalObjectReference getSecretRef(){
    return this.secretRef!=null?this.secretRef.build():null;
    }
    public A withSecretRef( LocalObjectReference secretRef){
    if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.add(this.secretRef);} return (A) this;
    }
    public SecretRefNested<A> withNewSecretRef(){
    return new SecretRefNestedImpl();
    }
    public SecretRefNested<A> withNewSecretRefLike( LocalObjectReference item){
    return new SecretRefNestedImpl(item);
    }
    public SecretRefNested<A> editSecretRef(){
    return withNewSecretRefLike(getSecretRef());
    }
    public A withNewSecretRef( String name){
    return withSecretRef(new LocalObjectReference(name));
    }
    public String getUser(){
    return this.user;
    }
    public A withUser( String user){
    this.user=user; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RBDVolumeSourceFluentImpl that = (RBDVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (keyring != null ? !keyring.equals(that.keyring) :that.keyring != null) return false;
if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
if (pool != null ? !pool.equals(that.pool) :that.pool != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
return true;

    }

    public class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretRefNested<N>> implements SecretRefNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretRefNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SecretRefNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endSecretRef(){
            return and();
        }
            public N and(){
            return (N) RBDVolumeSourceFluentImpl.this.withSecretRef(builder.build());
        }
    
}


}
