package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ReplicationControllerSpecFluentImpl<A extends ReplicationControllerSpecFluent<A>> extends BaseFluent<A> implements ReplicationControllerSpecFluent<A>{

     Integer replicas;     Map<String, String> selector = new HashMap();     VisitableBuilder<PodTemplateSpec, ?> template;
public ReplicationControllerSpecFluentImpl(){
    
}
public ReplicationControllerSpecFluentImpl( ReplicationControllerSpec instance ){
    this.withReplicas(instance.getReplicas()); this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

    public Integer getReplicas(){
    return this.replicas;
    }
    public A withReplicas( Integer replicas){
    this.replicas=replicas; return (A) this;
    }
    public A addToSelector( String key,  String value){
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }
    public A addToSelector( Map<String, String> map){
    if(map != null) { this.selector.putAll(map);} return (A)this;
    }
    public A removeFromSelector( String key){
    if(key != null) {this.selector.remove(key);} return (A)this;
    }
    public A removeFromSelector( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.selector.remove(key);}} return (A)this;
    }
    public Map<String, String> getSelector(){
    return this.selector;
    }
    public A withSelector( Map<String, String> selector){
    this.selector.clear();if (selector != null) {this.selector.putAll(selector);} return (A) this;
    }
    public PodTemplateSpec getTemplate(){
    return this.template!=null?this.template.build():null;
    }
    public A withTemplate( PodTemplateSpec template){
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.add(this.template);} return (A) this;
    }
    public TemplateNested<A> withNewTemplate(){
    return new TemplateNestedImpl();
    }
    public TemplateNested<A> withNewTemplateLike( PodTemplateSpec item){
    return new TemplateNestedImpl(item);
    }
    public TemplateNested<A> editTemplate(){
    return withNewTemplateLike(getTemplate());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl) o;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
if (template != null ? !template.equals(that.template) :that.template != null) return false;
return true;

    }

    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<TemplateNested<N>> implements TemplateNested<N>{

        private final PodTemplateSpecBuilder builder;
    
             TemplateNestedImpl (){
        this.builder = new PodTemplateSpecBuilder(this);
        }
             TemplateNestedImpl ( PodTemplateSpec item){
        this.builder = new PodTemplateSpecBuilder(this, item);
        }
    
            public N endTemplate(){
            return and();
        }
            public N and(){
            return (N) ReplicationControllerSpecFluentImpl.this.withTemplate(builder.build());
        }
    
}


}
