package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SecretListFluentImpl<A extends SecretListFluent<A>> extends BaseFluent<A> implements SecretListFluent<A>{

     String apiVersion;     List<VisitableBuilder<Secret, ?>> items = new ArrayList();     String kind;     VisitableBuilder<ListMeta, ?> metadata;
public SecretListFluentImpl(){
    
}
public SecretListFluentImpl( SecretList instance ){
    this.withApiVersion(instance.getApiVersion()); this.withItems(instance.getItems()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }
    public A removeFromItems( Secret ...items){
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }
    public List<Secret> getItems(){
    return build(items);
    }
    public A withItems( List<Secret> items){
    this.items.clear();if (items != null) {for (Secret item : items){this.addToItems(item);}} return (A) this;
    }
    public A withItems( Secret ...items){
    this.items.clear(); if (items != null) {for (Secret item :items){ this.addToItems(item);}} return (A) this;
    }
    public ItemsNested<A> addNewItem(){
    return new ItemsNestedImpl();
    }
    public ItemsNested<A> addNewItemLike( Secret item){
    return new ItemsNestedImpl(item);
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ListMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecretListFluentImpl that = (SecretListFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (items != null ? !items.equals(that.items) :that.items != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
return true;

    }

    public class ItemsNestedImpl<N> extends SecretFluentImpl<ItemsNested<N>> implements ItemsNested<N>{

        private final SecretBuilder builder;
    
             ItemsNestedImpl (){
        this.builder = new SecretBuilder(this);
        }
             ItemsNestedImpl ( Secret item){
        this.builder = new SecretBuilder(this, item);
        }
    
            public N endItem(){
            return and();
        }
            public N and(){
            return (N) SecretListFluentImpl.this.addToItems(builder.build());
        }
    
}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNestedImpl ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) SecretListFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
