package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class SecurityContextConstraintsFluentImpl<A extends SecurityContextConstraintsFluent<A>> extends BaseFluent<A> implements SecurityContextConstraintsFluent<A>{

     Boolean allowHostDirVolumePlugin;     Boolean allowHostIPC;     Boolean allowHostNetwork;     Boolean allowHostPID;     Boolean allowHostPorts;     Boolean allowPrivilegedContainer;     List<String> allowedCapabilities = new ArrayList();     String apiVersion;     List<String> defaultAddCapabilities = new ArrayList();     VisitableBuilder<FSGroupStrategyOptions, ?> fsGroup;     List<String> groups = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     Integer priority;     Boolean readOnlyRootFilesystem;     List<String> requiredDropCapabilities = new ArrayList();     VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;     VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;     VisitableBuilder<SupplementalGroupsStrategyOptions, ?> supplementalGroups;     List<String> users = new ArrayList();     List<String> volumes = new ArrayList();
public SecurityContextConstraintsFluentImpl(){
    
}
public SecurityContextConstraintsFluentImpl( SecurityContextConstraints instance ){
    this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); this.withAllowHostIPC(instance.getAllowHostIPC()); this.withAllowHostNetwork(instance.getAllowHostNetwork()); this.withAllowHostPID(instance.getAllowHostPID()); this.withAllowHostPorts(instance.getAllowHostPorts()); this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); this.withAllowedCapabilities(instance.getAllowedCapabilities()); this.withApiVersion(instance.getApiVersion()); this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); this.withFsGroup(instance.getFsGroup()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withPriority(instance.getPriority()); this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxContext(instance.getSeLinuxContext()); this.withSupplementalGroups(instance.getSupplementalGroups()); this.withUsers(instance.getUsers()); this.withVolumes(instance.getVolumes()); 
}

    public Boolean isAllowHostDirVolumePlugin(){
    return this.allowHostDirVolumePlugin;
    }
    public A withAllowHostDirVolumePlugin( Boolean allowHostDirVolumePlugin){
    this.allowHostDirVolumePlugin=allowHostDirVolumePlugin; return (A) this;
    }
    public Boolean isAllowHostIPC(){
    return this.allowHostIPC;
    }
    public A withAllowHostIPC( Boolean allowHostIPC){
    this.allowHostIPC=allowHostIPC; return (A) this;
    }
    public Boolean isAllowHostNetwork(){
    return this.allowHostNetwork;
    }
    public A withAllowHostNetwork( Boolean allowHostNetwork){
    this.allowHostNetwork=allowHostNetwork; return (A) this;
    }
    public Boolean isAllowHostPID(){
    return this.allowHostPID;
    }
    public A withAllowHostPID( Boolean allowHostPID){
    this.allowHostPID=allowHostPID; return (A) this;
    }
    public Boolean isAllowHostPorts(){
    return this.allowHostPorts;
    }
    public A withAllowHostPorts( Boolean allowHostPorts){
    this.allowHostPorts=allowHostPorts; return (A) this;
    }
    public Boolean isAllowPrivilegedContainer(){
    return this.allowPrivilegedContainer;
    }
    public A withAllowPrivilegedContainer( Boolean allowPrivilegedContainer){
    this.allowPrivilegedContainer=allowPrivilegedContainer; return (A) this;
    }
    public A addToAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }
    public A removeFromAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.remove(item);} return (A)this;
    }
    public List<String> getAllowedCapabilities(){
    return this.allowedCapabilities;
    }
    public A withAllowedCapabilities( List<String> allowedCapabilities){
    this.allowedCapabilities.clear();if (allowedCapabilities != null) {for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} return (A) this;
    }
    public A withAllowedCapabilities( String ...allowedCapabilities){
    this.allowedCapabilities.clear(); if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
    }
    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToDefaultAddCapabilities( String ...items){
    for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }
    public A removeFromDefaultAddCapabilities( String ...items){
    for (String item : items) {this.defaultAddCapabilities.remove(item);} return (A)this;
    }
    public List<String> getDefaultAddCapabilities(){
    return this.defaultAddCapabilities;
    }
    public A withDefaultAddCapabilities( List<String> defaultAddCapabilities){
    this.defaultAddCapabilities.clear();if (defaultAddCapabilities != null) {for (String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} return (A) this;
    }
    public A withDefaultAddCapabilities( String ...defaultAddCapabilities){
    this.defaultAddCapabilities.clear(); if (defaultAddCapabilities != null) {for (String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
    }
    public FSGroupStrategyOptions getFsGroup(){
    return this.fsGroup!=null?this.fsGroup.build():null;
    }
    public A withFsGroup( FSGroupStrategyOptions fsGroup){
    if (fsGroup!=null){ this.fsGroup= new FSGroupStrategyOptionsBuilder(fsGroup); _visitables.add(this.fsGroup);} return (A) this;
    }
    public FsGroupNested<A> withNewFsGroup(){
    return new FsGroupNestedImpl();
    }
    public FsGroupNested<A> withNewFsGroupLike( FSGroupStrategyOptions item){
    return new FsGroupNestedImpl(item);
    }
    public FsGroupNested<A> editFsGroup(){
    return withNewFsGroupLike(getFsGroup());
    }
    public A addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (A)this;
    }
    public A removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (A)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public A withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (A) this;
    }
    public A withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public Integer getPriority(){
    return this.priority;
    }
    public A withPriority( Integer priority){
    this.priority=priority; return (A) this;
    }
    public Boolean isReadOnlyRootFilesystem(){
    return this.readOnlyRootFilesystem;
    }
    public A withReadOnlyRootFilesystem( Boolean readOnlyRootFilesystem){
    this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }
    public A addToRequiredDropCapabilities( String ...items){
    for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }
    public A removeFromRequiredDropCapabilities( String ...items){
    for (String item : items) {this.requiredDropCapabilities.remove(item);} return (A)this;
    }
    public List<String> getRequiredDropCapabilities(){
    return this.requiredDropCapabilities;
    }
    public A withRequiredDropCapabilities( List<String> requiredDropCapabilities){
    this.requiredDropCapabilities.clear();if (requiredDropCapabilities != null) {for (String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} return (A) this;
    }
    public A withRequiredDropCapabilities( String ...requiredDropCapabilities){
    this.requiredDropCapabilities.clear(); if (requiredDropCapabilities != null) {for (String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
    }
    public RunAsUserStrategyOptions getRunAsUser(){
    return this.runAsUser!=null?this.runAsUser.build():null;
    }
    public A withRunAsUser( RunAsUserStrategyOptions runAsUser){
    if (runAsUser!=null){ this.runAsUser= new RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.add(this.runAsUser);} return (A) this;
    }
    public RunAsUserNested<A> withNewRunAsUser(){
    return new RunAsUserNestedImpl();
    }
    public RunAsUserNested<A> withNewRunAsUserLike( RunAsUserStrategyOptions item){
    return new RunAsUserNestedImpl(item);
    }
    public RunAsUserNested<A> editRunAsUser(){
    return withNewRunAsUserLike(getRunAsUser());
    }
    public A withNewRunAsUser( String type,  Long uid,  Long uidRangeMax,  Long uidRangeMin){
    return withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }
    public SELinuxContextStrategyOptions getSeLinuxContext(){
    return this.seLinuxContext!=null?this.seLinuxContext.build():null;
    }
    public A withSeLinuxContext( SELinuxContextStrategyOptions seLinuxContext){
    if (seLinuxContext!=null){ this.seLinuxContext= new SELinuxContextStrategyOptionsBuilder(seLinuxContext); _visitables.add(this.seLinuxContext);} return (A) this;
    }
    public SeLinuxContextNested<A> withNewSeLinuxContext(){
    return new SeLinuxContextNestedImpl();
    }
    public SeLinuxContextNested<A> withNewSeLinuxContextLike( SELinuxContextStrategyOptions item){
    return new SeLinuxContextNestedImpl(item);
    }
    public SeLinuxContextNested<A> editSeLinuxContext(){
    return withNewSeLinuxContextLike(getSeLinuxContext());
    }
    public SupplementalGroupsStrategyOptions getSupplementalGroups(){
    return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }
    public A withSupplementalGroups( SupplementalGroupsStrategyOptions supplementalGroups){
    if (supplementalGroups!=null){ this.supplementalGroups= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.add(this.supplementalGroups);} return (A) this;
    }
    public SupplementalGroupsNested<A> withNewSupplementalGroups(){
    return new SupplementalGroupsNestedImpl();
    }
    public SupplementalGroupsNested<A> withNewSupplementalGroupsLike( SupplementalGroupsStrategyOptions item){
    return new SupplementalGroupsNestedImpl(item);
    }
    public SupplementalGroupsNested<A> editSupplementalGroups(){
    return withNewSupplementalGroupsLike(getSupplementalGroups());
    }
    public A addToUsers( String ...items){
    for (String item : items) {this.users.add(item);} return (A)this;
    }
    public A removeFromUsers( String ...items){
    for (String item : items) {this.users.remove(item);} return (A)this;
    }
    public List<String> getUsers(){
    return this.users;
    }
    public A withUsers( List<String> users){
    this.users.clear();if (users != null) {for (String item : users){this.addToUsers(item);}} return (A) this;
    }
    public A withUsers( String ...users){
    this.users.clear(); if (users != null) {for (String item :users){ this.addToUsers(item);}} return (A) this;
    }
    public A addToVolumes( String ...items){
    for (String item : items) {this.volumes.add(item);} return (A)this;
    }
    public A removeFromVolumes( String ...items){
    for (String item : items) {this.volumes.remove(item);} return (A)this;
    }
    public List<String> getVolumes(){
    return this.volumes;
    }
    public A withVolumes( List<String> volumes){
    this.volumes.clear();if (volumes != null) {for (String item : volumes){this.addToVolumes(item);}} return (A) this;
    }
    public A withVolumes( String ...volumes){
    this.volumes.clear(); if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl) o;
if (allowHostDirVolumePlugin != null ? !allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) :that.allowHostDirVolumePlugin != null) return false;
if (allowHostIPC != null ? !allowHostIPC.equals(that.allowHostIPC) :that.allowHostIPC != null) return false;
if (allowHostNetwork != null ? !allowHostNetwork.equals(that.allowHostNetwork) :that.allowHostNetwork != null) return false;
if (allowHostPID != null ? !allowHostPID.equals(that.allowHostPID) :that.allowHostPID != null) return false;
if (allowHostPorts != null ? !allowHostPorts.equals(that.allowHostPorts) :that.allowHostPorts != null) return false;
if (allowPrivilegedContainer != null ? !allowPrivilegedContainer.equals(that.allowPrivilegedContainer) :that.allowPrivilegedContainer != null) return false;
if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
if (seLinuxContext != null ? !seLinuxContext.equals(that.seLinuxContext) :that.seLinuxContext != null) return false;
if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
if (users != null ? !users.equals(that.users) :that.users != null) return false;
if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
return true;

    }

    public class FsGroupNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<FsGroupNested<N>> implements FsGroupNested<N>{

        private final FSGroupStrategyOptionsBuilder builder;
    
             FsGroupNestedImpl (){
        this.builder = new FSGroupStrategyOptionsBuilder(this);
        }
             FsGroupNestedImpl ( FSGroupStrategyOptions item){
        this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withFsGroup(builder.build());
        }
            public N endFsGroup(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RunAsUserNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<RunAsUserNested<N>> implements RunAsUserNested<N>{

        private final RunAsUserStrategyOptionsBuilder builder;
    
             RunAsUserNestedImpl (){
        this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }
             RunAsUserNestedImpl ( RunAsUserStrategyOptions item){
        this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }
    
            public N endRunAsUser(){
            return and();
        }
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withRunAsUser(builder.build());
        }
    
}
    public class SeLinuxContextNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<SeLinuxContextNested<N>> implements SeLinuxContextNested<N>{

        private final SELinuxContextStrategyOptionsBuilder builder;
    
             SeLinuxContextNestedImpl (){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }
             SeLinuxContextNestedImpl ( SELinuxContextStrategyOptions item){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(builder.build());
        }
            public N endSeLinuxContext(){
            return and();
        }
    
}
    public class SupplementalGroupsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<SupplementalGroupsNested<N>> implements SupplementalGroupsNested<N>{

        private final SupplementalGroupsStrategyOptionsBuilder builder;
    
             SupplementalGroupsNestedImpl (){
        this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }
             SupplementalGroupsNestedImpl ( SupplementalGroupsStrategyOptions item){
        this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(builder.build());
        }
            public N endSupplementalGroups(){
            return and();
        }
    
}


}
