package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface SecurityContextFluent<A extends SecurityContextFluent<A>> extends Fluent<A>{


    public Capabilities getCapabilities();    public A withCapabilities( Capabilities capabilities);    public CapabilitiesNested<A> withNewCapabilities();    public CapabilitiesNested<A> withNewCapabilitiesLike( Capabilities item);    public CapabilitiesNested<A> editCapabilities();    public Boolean isPrivileged();    public A withPrivileged( Boolean privileged);    public Boolean isReadOnlyRootFilesystem();    public A withReadOnlyRootFilesystem( Boolean readOnlyRootFilesystem);    public Boolean isRunAsNonRoot();    public A withRunAsNonRoot( Boolean runAsNonRoot);    public Long getRunAsUser();    public A withRunAsUser( Long runAsUser);    public SELinuxOptions getSeLinuxOptions();    public A withSeLinuxOptions( SELinuxOptions seLinuxOptions);    public SeLinuxOptionsNested<A> withNewSeLinuxOptions();    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike( SELinuxOptions item);    public SeLinuxOptionsNested<A> editSeLinuxOptions();    public A withNewSeLinuxOptions( String level,  String role,  String type,  String user);
    public interface CapabilitiesNested<N> extends Nested<N>,CapabilitiesFluent<CapabilitiesNested<N>>{
            public N endCapabilities();            public N and();        
}

    public interface SeLinuxOptionsNested<N> extends Nested<N>,SELinuxOptionsFluent<SeLinuxOptionsNested<N>>{
            public N endSeLinuxOptions();            public N and();        
}


}
