package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface ServiceAccountFluent<A extends ServiceAccountFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public A addToImagePullSecrets( LocalObjectReference ...items);    public A removeFromImagePullSecrets( LocalObjectReference ...items);    public List<LocalObjectReference> getImagePullSecrets();    public A withImagePullSecrets( List<LocalObjectReference> imagePullSecrets);    public A withImagePullSecrets( LocalObjectReference ...imagePullSecrets);    public ImagePullSecretsNested<A> addNewImagePullSecret();    public ImagePullSecretsNested<A> addNewImagePullSecretLike( LocalObjectReference item);    public A addNewImagePullSecret( String name);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public A addToSecrets( ObjectReference ...items);    public A removeFromSecrets( ObjectReference ...items);    public List<ObjectReference> getSecrets();    public A withSecrets( List<ObjectReference> secrets);    public A withSecrets( ObjectReference ...secrets);    public SecretsNested<A> addNewSecret();    public SecretsNested<A> addNewSecretLike( ObjectReference item);
    public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<ImagePullSecretsNested<N>>{
            public N and();            public N endImagePullSecret();        
}

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SecretsNested<N> extends Nested<N>,ObjectReferenceFluent<SecretsNested<N>>{
            public N and();            public N endSecret();        
}


}
