package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class StatusDetailsBuilder extends StatusDetailsFluentImpl<StatusDetailsBuilder> implements VisitableBuilder<StatusDetails,StatusDetailsBuilder>{

     StatusDetailsFluent<?> fluent;
public StatusDetailsBuilder(){
    this(new StatusDetails());
}
public StatusDetailsBuilder( StatusDetailsFluent<?> fluent ){
    this(fluent, new StatusDetails());
}
public StatusDetailsBuilder( StatusDetailsFluent<?> fluent , StatusDetails instance ){
    this.fluent = fluent; fluent.withCauses(instance.getCauses()); fluent.withGroup(instance.getGroup()); fluent.withKind(instance.getKind()); fluent.withName(instance.getName()); fluent.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}
public StatusDetailsBuilder( StatusDetails instance ){
    this.fluent = this; this.withCauses(instance.getCauses()); this.withGroup(instance.getGroup()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}

public StatusDetails build(){
    StatusDetails buildable = new StatusDetails(fluent.getCauses(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getRetryAfterSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
StatusDetailsBuilder that = (StatusDetailsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
