package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class CPUTargetUtilizationBuilder extends CPUTargetUtilizationFluentImpl<CPUTargetUtilizationBuilder> implements VisitableBuilder<CPUTargetUtilization,CPUTargetUtilizationBuilder>{

     CPUTargetUtilizationFluent<?> fluent;
public CPUTargetUtilizationBuilder(){
    this(new CPUTargetUtilization());
}
public CPUTargetUtilizationBuilder( CPUTargetUtilizationFluent<?> fluent ){
    this(fluent, new CPUTargetUtilization());
}
public CPUTargetUtilizationBuilder( CPUTargetUtilizationFluent<?> fluent , CPUTargetUtilization instance ){
    this.fluent = fluent; fluent.withTargetPercentage(instance.getTargetPercentage()); 
}
public CPUTargetUtilizationBuilder( CPUTargetUtilization instance ){
    this.fluent = this; this.withTargetPercentage(instance.getTargetPercentage()); 
}

public CPUTargetUtilization build(){
    CPUTargetUtilization buildable = new CPUTargetUtilization(fluent.getTargetPercentage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CPUTargetUtilizationBuilder that = (CPUTargetUtilizationBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
