package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class CPUTargetUtilizationFluentImpl<A extends CPUTargetUtilizationFluent<A>> extends BaseFluent<A> implements CPUTargetUtilizationFluent<A>{

     Integer targetPercentage;
public CPUTargetUtilizationFluentImpl(){
    
}
public CPUTargetUtilizationFluentImpl( CPUTargetUtilization instance ){
    this.withTargetPercentage(instance.getTargetPercentage()); 
}

    public Integer getTargetPercentage(){
    return this.targetPercentage;
    }
    public A withTargetPercentage( Integer targetPercentage){
    this.targetPercentage=targetPercentage; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CPUTargetUtilizationFluentImpl that = (CPUTargetUtilizationFluentImpl) o;
if (targetPercentage != null ? !targetPercentage.equals(that.targetPercentage) :that.targetPercentage != null) return false;
return true;

    }



}
