package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentStatusFluentImpl<A extends DeploymentStatusFluent<A>> extends BaseFluent<A> implements DeploymentStatusFluent<A>{

     Integer availableReplicas;     Long observedGeneration;     Integer replicas;     Integer unavailableReplicas;     Integer updatedReplicas;
public DeploymentStatusFluentImpl(){
    
}
public DeploymentStatusFluentImpl( DeploymentStatus instance ){
    this.withAvailableReplicas(instance.getAvailableReplicas()); this.withObservedGeneration(instance.getObservedGeneration()); this.withReplicas(instance.getReplicas()); this.withUnavailableReplicas(instance.getUnavailableReplicas()); this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
}

    public Integer getAvailableReplicas(){
    return this.availableReplicas;
    }
    public A withAvailableReplicas( Integer availableReplicas){
    this.availableReplicas=availableReplicas; return (A) this;
    }
    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public A withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (A) this;
    }
    public Integer getReplicas(){
    return this.replicas;
    }
    public A withReplicas( Integer replicas){
    this.replicas=replicas; return (A) this;
    }
    public Integer getUnavailableReplicas(){
    return this.unavailableReplicas;
    }
    public A withUnavailableReplicas( Integer unavailableReplicas){
    this.unavailableReplicas=unavailableReplicas; return (A) this;
    }
    public Integer getUpdatedReplicas(){
    return this.updatedReplicas;
    }
    public A withUpdatedReplicas( Integer updatedReplicas){
    this.updatedReplicas=updatedReplicas; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentStatusFluentImpl that = (DeploymentStatusFluentImpl) o;
if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
return true;

    }



}
