package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class HTTPIngressRuleValueBuilder extends HTTPIngressRuleValueFluentImpl<HTTPIngressRuleValueBuilder> implements VisitableBuilder<HTTPIngressRuleValue,HTTPIngressRuleValueBuilder>{

     HTTPIngressRuleValueFluent<?> fluent;
public HTTPIngressRuleValueBuilder(){
    this(new HTTPIngressRuleValue());
}
public HTTPIngressRuleValueBuilder( HTTPIngressRuleValueFluent<?> fluent ){
    this(fluent, new HTTPIngressRuleValue());
}
public HTTPIngressRuleValueBuilder( HTTPIngressRuleValueFluent<?> fluent , HTTPIngressRuleValue instance ){
    this.fluent = fluent; fluent.withPaths(instance.getPaths()); 
}
public HTTPIngressRuleValueBuilder( HTTPIngressRuleValue instance ){
    this.fluent = this; this.withPaths(instance.getPaths()); 
}

public HTTPIngressRuleValue build(){
    HTTPIngressRuleValue buildable = new HTTPIngressRuleValue(fluent.getPaths());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HTTPIngressRuleValueBuilder that = (HTTPIngressRuleValueBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
