package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface HorizontalPodAutoscalerFluent<A extends HorizontalPodAutoscalerFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public HorizontalPodAutoscalerSpec getSpec();    public A withSpec( HorizontalPodAutoscalerSpec spec);    public SpecNested<A> withNewSpec();    public SpecNested<A> withNewSpecLike( HorizontalPodAutoscalerSpec item);    public SpecNested<A> editSpec();    public HorizontalPodAutoscalerStatus getStatus();    public A withStatus( HorizontalPodAutoscalerStatus status);    public StatusNested<A> withNewStatus();    public StatusNested<A> withNewStatusLike( HorizontalPodAutoscalerStatus item);    public StatusNested<A> editStatus();    public A withNewStatus( Integer currentCPUUtilizationPercentage,  Integer currentReplicas,  Integer desiredReplicas,  String lastScaleTime,  Long observedGeneration);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>,HorizontalPodAutoscalerSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>,HorizontalPodAutoscalerStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
