package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>> extends BaseFluent<A> implements HorizontalPodAutoscalerStatusFluent<A>{

     Integer currentCPUUtilizationPercentage;     Integer currentReplicas;     Integer desiredReplicas;     String lastScaleTime;     Long observedGeneration;
public HorizontalPodAutoscalerStatusFluentImpl(){
    
}
public HorizontalPodAutoscalerStatusFluentImpl( HorizontalPodAutoscalerStatus instance ){
    this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage()); this.withCurrentReplicas(instance.getCurrentReplicas()); this.withDesiredReplicas(instance.getDesiredReplicas()); this.withLastScaleTime(instance.getLastScaleTime()); this.withObservedGeneration(instance.getObservedGeneration()); 
}

    public Integer getCurrentCPUUtilizationPercentage(){
    return this.currentCPUUtilizationPercentage;
    }
    public A withCurrentCPUUtilizationPercentage( Integer currentCPUUtilizationPercentage){
    this.currentCPUUtilizationPercentage=currentCPUUtilizationPercentage; return (A) this;
    }
    public Integer getCurrentReplicas(){
    return this.currentReplicas;
    }
    public A withCurrentReplicas( Integer currentReplicas){
    this.currentReplicas=currentReplicas; return (A) this;
    }
    public Integer getDesiredReplicas(){
    return this.desiredReplicas;
    }
    public A withDesiredReplicas( Integer desiredReplicas){
    this.desiredReplicas=desiredReplicas; return (A) this;
    }
    public String getLastScaleTime(){
    return this.lastScaleTime;
    }
    public A withLastScaleTime( String lastScaleTime){
    this.lastScaleTime=lastScaleTime; return (A) this;
    }
    public Long getObservedGeneration(){
    return this.observedGeneration;
    }
    public A withObservedGeneration( Long observedGeneration){
    this.observedGeneration=observedGeneration; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl) o;
if (currentCPUUtilizationPercentage != null ? !currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) :that.currentCPUUtilizationPercentage != null) return false;
if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
if (desiredReplicas != null ? !desiredReplicas.equals(that.desiredReplicas) :that.desiredReplicas != null) return false;
if (lastScaleTime != null ? !lastScaleTime.equals(that.lastScaleTime) :that.lastScaleTime != null) return false;
if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
return true;

    }



}
