package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.LoadBalancerStatus;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentImpl;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class IngressStatusFluentImpl<A extends IngressStatusFluent<A>> extends BaseFluent<A> implements IngressStatusFluent<A>{

     VisitableBuilder<LoadBalancerStatus, ?> loadBalancer;
public IngressStatusFluentImpl(){
    
}
public IngressStatusFluentImpl( IngressStatus instance ){
    this.withLoadBalancer(instance.getLoadBalancer()); 
}

    public LoadBalancerStatus getLoadBalancer(){
    return this.loadBalancer!=null?this.loadBalancer.build():null;
    }
    public A withLoadBalancer( LoadBalancerStatus loadBalancer){
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerStatusBuilder(loadBalancer); _visitables.add(this.loadBalancer);} return (A) this;
    }
    public LoadBalancerNested<A> withNewLoadBalancer(){
    return new LoadBalancerNestedImpl();
    }
    public LoadBalancerNested<A> withNewLoadBalancerLike( LoadBalancerStatus item){
    return new LoadBalancerNestedImpl(item);
    }
    public LoadBalancerNested<A> editLoadBalancer(){
    return withNewLoadBalancerLike(getLoadBalancer());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressStatusFluentImpl that = (IngressStatusFluentImpl) o;
if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
return true;

    }

    public class LoadBalancerNestedImpl<N> extends LoadBalancerStatusFluentImpl<LoadBalancerNested<N>> implements LoadBalancerNested<N>{

        private final LoadBalancerStatusBuilder builder;
    
             LoadBalancerNestedImpl (){
        this.builder = new LoadBalancerStatusBuilder(this);
        }
             LoadBalancerNestedImpl ( LoadBalancerStatus item){
        this.builder = new LoadBalancerStatusBuilder(this, item);
        }
    
            public N and(){
            return (N) IngressStatusFluentImpl.this.withLoadBalancer(builder.build());
        }
            public N endLoadBalancer(){
            return and();
        }
    
}


}
