package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;

public class IngressTLSBuilder extends IngressTLSFluentImpl<IngressTLSBuilder> implements VisitableBuilder<IngressTLS,IngressTLSBuilder>{

     IngressTLSFluent<?> fluent;
public IngressTLSBuilder(){
    this(new IngressTLS());
}
public IngressTLSBuilder( IngressTLSFluent<?> fluent ){
    this(fluent, new IngressTLS());
}
public IngressTLSBuilder( IngressTLSFluent<?> fluent , IngressTLS instance ){
    this.fluent = fluent; fluent.withHosts(instance.getHosts()); fluent.withSecretName(instance.getSecretName()); 
}
public IngressTLSBuilder( IngressTLS instance ){
    this.fluent = this; this.withHosts(instance.getHosts()); this.withSecretName(instance.getSecretName()); 
}

public IngressTLS build(){
    IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
IngressTLSBuilder that = (IngressTLSBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
