package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface JobFluent<A extends JobFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public JobSpec getSpec();    public A withSpec( JobSpec spec);    public SpecNested<A> withNewSpec();    public SpecNested<A> withNewSpecLike( JobSpec item);    public SpecNested<A> editSpec();    public JobStatus getStatus();    public A withStatus( JobStatus status);    public StatusNested<A> withNewStatus();    public StatusNested<A> withNewStatusLike( JobStatus item);    public StatusNested<A> editStatus();
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>,JobSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>,JobStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
