package io.fabric8.kubernetes.api.model.extensions;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;

public class ThirdPartyResourceFluentImpl<A extends ThirdPartyResourceFluent<A>> extends BaseFluent<A> implements ThirdPartyResourceFluent<A>{

     String apiVersion;     String description;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<VisitableBuilder<APIVersion, ?>> versions = new ArrayList();
public ThirdPartyResourceFluentImpl(){
    
}
public ThirdPartyResourceFluentImpl( ThirdPartyResource instance ){
    this.withApiVersion(instance.getApiVersion()); this.withDescription(instance.getDescription()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withVersions(instance.getVersions()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public String getDescription(){
    return this.description;
    }
    public A withDescription( String description){
    this.description=description; return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public A addToVersions( APIVersion ...items){
    for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(builder);this.versions.add(builder);} return (A)this;
    }
    public A removeFromVersions( APIVersion ...items){
    for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.remove(builder);this.versions.remove(builder);} return (A)this;
    }
    public List<APIVersion> getVersions(){
    return build(versions);
    }
    public A withVersions( List<APIVersion> versions){
    this.versions.clear();if (versions != null) {for (APIVersion item : versions){this.addToVersions(item);}} return (A) this;
    }
    public A withVersions( APIVersion ...versions){
    this.versions.clear(); if (versions != null) {for (APIVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }
    public VersionsNested<A> addNewVersion(){
    return new VersionsNestedImpl();
    }
    public VersionsNested<A> addNewVersionLike( APIVersion item){
    return new VersionsNestedImpl(item);
    }
    public A addNewVersion( String name){
    return addToVersions(new APIVersion(name));
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (description != null ? !description.equals(that.description) :that.description != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class VersionsNestedImpl<N> extends APIVersionFluentImpl<VersionsNested<N>> implements VersionsNested<N>{

        private final APIVersionBuilder builder;
    
             VersionsNestedImpl ( APIVersion item){
        this.builder = new APIVersionBuilder(this, item);
        }
             VersionsNestedImpl (){
        this.builder = new APIVersionBuilder(this);
        }
    
            public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.addToVersions(builder.build());
        }
            public N endVersion(){
            return and();
        }
    
}


}
