package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildConfigSpecFluent<A extends BuildConfigSpecFluent<A>> extends Fluent<A>{


    public Long getCompletionDeadlineSeconds();    public A withCompletionDeadlineSeconds( Long completionDeadlineSeconds);    public BuildOutput getOutput();    public A withOutput( BuildOutput output);    public OutputNested<A> withNewOutput();    public OutputNested<A> withNewOutputLike( BuildOutput item);    public OutputNested<A> editOutput();    public BuildPostCommitSpec getPostCommit();    public A withPostCommit( BuildPostCommitSpec postCommit);    public PostCommitNested<A> withNewPostCommit();    public PostCommitNested<A> withNewPostCommitLike( BuildPostCommitSpec item);    public PostCommitNested<A> editPostCommit();    public ResourceRequirements getResources();    public A withResources( ResourceRequirements resources);    public ResourcesNested<A> withNewResources();    public ResourcesNested<A> withNewResourcesLike( ResourceRequirements item);    public ResourcesNested<A> editResources();    public SourceRevision getRevision();    public A withRevision( SourceRevision revision);    public RevisionNested<A> withNewRevision();    public RevisionNested<A> withNewRevisionLike( SourceRevision item);    public RevisionNested<A> editRevision();    public String getRunPolicy();    public A withRunPolicy( String runPolicy);    public String getServiceAccount();    public A withServiceAccount( String serviceAccount);    public BuildSource getSource();    public A withSource( BuildSource source);    public SourceNested<A> withNewSource();    public SourceNested<A> withNewSourceLike( BuildSource item);    public SourceNested<A> editSource();    public BuildStrategy getStrategy();    public A withStrategy( BuildStrategy strategy);    public StrategyNested<A> withNewStrategy();    public StrategyNested<A> withNewStrategyLike( BuildStrategy item);    public StrategyNested<A> editStrategy();    public A addToTriggers( BuildTriggerPolicy ...items);    public A removeFromTriggers( BuildTriggerPolicy ...items);    public List<BuildTriggerPolicy> getTriggers();    public A withTriggers( List<BuildTriggerPolicy> triggers);    public A withTriggers( BuildTriggerPolicy ...triggers);    public TriggersNested<A> addNewTrigger();    public TriggersNested<A> addNewTriggerLike( BuildTriggerPolicy item);
    public interface OutputNested<N> extends Nested<N>,BuildOutputFluent<OutputNested<N>>{
            public N endOutput();            public N and();        
}

    public interface PostCommitNested<N> extends Nested<N>,BuildPostCommitSpecFluent<PostCommitNested<N>>{
            public N and();            public N endPostCommit();        
}

    public interface ResourcesNested<N> extends Nested<N>,ResourceRequirementsFluent<ResourcesNested<N>>{
            public N and();            public N endResources();        
}

    public interface RevisionNested<N> extends Nested<N>,SourceRevisionFluent<RevisionNested<N>>{
            public N endRevision();            public N and();        
}

    public interface SourceNested<N> extends Nested<N>,BuildSourceFluent<SourceNested<N>>{
            public N and();            public N endSource();        
}

    public interface StrategyNested<N> extends Nested<N>,BuildStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TriggersNested<N> extends Nested<N>,BuildTriggerPolicyFluent<TriggersNested<N>>{
            public N endTrigger();            public N and();        
}


}
