package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>> extends BaseFluent<A> implements BuildOutputFluent<A>{

     VisitableBuilder<LocalObjectReference, ?> pushSecret;     VisitableBuilder<ObjectReference, ?> to;
public BuildOutputFluentImpl(){
    
}
public BuildOutputFluentImpl( BuildOutput instance ){
    this.withPushSecret(instance.getPushSecret()); this.withTo(instance.getTo()); 
}

    public LocalObjectReference getPushSecret(){
    return this.pushSecret!=null?this.pushSecret.build():null;
    }
    public A withPushSecret( LocalObjectReference pushSecret){
    if (pushSecret!=null){ this.pushSecret= new LocalObjectReferenceBuilder(pushSecret); _visitables.add(this.pushSecret);} return (A) this;
    }
    public PushSecretNested<A> withNewPushSecret(){
    return new PushSecretNestedImpl();
    }
    public PushSecretNested<A> withNewPushSecretLike( LocalObjectReference item){
    return new PushSecretNestedImpl(item);
    }
    public PushSecretNested<A> editPushSecret(){
    return withNewPushSecretLike(getPushSecret());
    }
    public A withNewPushSecret( String name){
    return withPushSecret(new LocalObjectReference(name));
    }
    public ObjectReference getTo(){
    return this.to!=null?this.to.build():null;
    }
    public A withTo( ObjectReference to){
    if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (A) this;
    }
    public ToNested<A> withNewTo(){
    return new ToNestedImpl();
    }
    public ToNested<A> withNewToLike( ObjectReference item){
    return new ToNestedImpl(item);
    }
    public ToNested<A> editTo(){
    return withNewToLike(getTo());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildOutputFluentImpl that = (BuildOutputFluentImpl) o;
if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
if (to != null ? !to.equals(that.to) :that.to != null) return false;
return true;

    }

    public class PushSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<PushSecretNested<N>> implements PushSecretNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             PushSecretNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             PushSecretNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endPushSecret(){
            return and();
        }
            public N and(){
            return (N) BuildOutputFluentImpl.this.withPushSecret(builder.build());
        }
    
}
    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<ToNested<N>> implements ToNested<N>{

        private final ObjectReferenceBuilder builder;
    
             ToNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             ToNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildOutputFluentImpl.this.withTo(builder.build());
        }
            public N endTo(){
            return and();
        }
    
}


}
