package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface BuildStrategyFluent<A extends BuildStrategyFluent<A>> extends Fluent<A>{


    public CustomBuildStrategy getCustomStrategy();    public A withCustomStrategy( CustomBuildStrategy customStrategy);    public CustomStrategyNested<A> withNewCustomStrategy();    public CustomStrategyNested<A> withNewCustomStrategyLike( CustomBuildStrategy item);    public CustomStrategyNested<A> editCustomStrategy();    public DockerBuildStrategy getDockerStrategy();    public A withDockerStrategy( DockerBuildStrategy dockerStrategy);    public DockerStrategyNested<A> withNewDockerStrategy();    public DockerStrategyNested<A> withNewDockerStrategyLike( DockerBuildStrategy item);    public DockerStrategyNested<A> editDockerStrategy();    public JenkinsPipelineBuildStrategy getJenkinsPipelineStrategy();    public A withJenkinsPipelineStrategy( JenkinsPipelineBuildStrategy jenkinsPipelineStrategy);    public JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategy();    public JenkinsPipelineStrategyNested<A> withNewJenkinsPipelineStrategyLike( JenkinsPipelineBuildStrategy item);    public JenkinsPipelineStrategyNested<A> editJenkinsPipelineStrategy();    public A withNewJenkinsPipelineStrategy( String jenkinsfile,  String jenkinsfilePath);    public SourceBuildStrategy getSourceStrategy();    public A withSourceStrategy( SourceBuildStrategy sourceStrategy);    public SourceStrategyNested<A> withNewSourceStrategy();    public SourceStrategyNested<A> withNewSourceStrategyLike( SourceBuildStrategy item);    public SourceStrategyNested<A> editSourceStrategy();    public String getType();    public A withType( String type);
    public interface CustomStrategyNested<N> extends Nested<N>,CustomBuildStrategyFluent<CustomStrategyNested<N>>{
            public N endCustomStrategy();            public N and();        
}

    public interface DockerStrategyNested<N> extends Nested<N>,DockerBuildStrategyFluent<DockerStrategyNested<N>>{
            public N and();            public N endDockerStrategy();        
}

    public interface JenkinsPipelineStrategyNested<N> extends Nested<N>,JenkinsPipelineBuildStrategyFluent<JenkinsPipelineStrategyNested<N>>{
            public N endJenkinsPipelineStrategy();            public N and();        
}

    public interface SourceStrategyNested<N> extends Nested<N>,SourceBuildStrategyFluent<SourceStrategyNested<N>>{
            public N and();            public N endSourceStrategy();        
}


}
