package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildTriggerPolicyBuilder extends BuildTriggerPolicyFluentImpl<BuildTriggerPolicyBuilder> implements VisitableBuilder<BuildTriggerPolicy,BuildTriggerPolicyBuilder>{

     BuildTriggerPolicyFluent<?> fluent;
public BuildTriggerPolicyBuilder(){
    this(new BuildTriggerPolicy());
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicyFluent<?> fluent ){
    this(fluent, new BuildTriggerPolicy());
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicyFluent<?> fluent , BuildTriggerPolicy instance ){
    this.fluent = fluent; fluent.withGeneric(instance.getGeneric()); fluent.withGithub(instance.getGithub()); fluent.withImageChange(instance.getImageChange()); fluent.withType(instance.getType()); 
}
public BuildTriggerPolicyBuilder( BuildTriggerPolicy instance ){
    this.fluent = this; this.withGeneric(instance.getGeneric()); this.withGithub(instance.getGithub()); this.withImageChange(instance.getImageChange()); this.withType(instance.getType()); 
}

public BuildTriggerPolicy build(){
    BuildTriggerPolicy buildable = new BuildTriggerPolicy(fluent.getGeneric(),fluent.getGithub(),fluent.getImageChange(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildTriggerPolicyBuilder that = (BuildTriggerPolicyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
