package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface ClusterPolicyBindingFluent<A extends ClusterPolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();    public A withApiVersion( String apiVersion);    public String getKind();    public A withKind( String kind);    public String getLastModified();    public A withLastModified( String lastModified);    public ObjectMeta getMetadata();    public A withMetadata( ObjectMeta metadata);    public MetadataNested<A> withNewMetadata();    public MetadataNested<A> withNewMetadataLike( ObjectMeta item);    public MetadataNested<A> editMetadata();    public ObjectReference getPolicyRef();    public A withPolicyRef( ObjectReference policyRef);    public PolicyRefNested<A> withNewPolicyRef();    public PolicyRefNested<A> withNewPolicyRefLike( ObjectReference item);    public PolicyRefNested<A> editPolicyRef();    public A addToRoleBindings( NamedClusterRoleBinding ...items);    public A removeFromRoleBindings( NamedClusterRoleBinding ...items);    public List<NamedClusterRoleBinding> getRoleBindings();    public A withRoleBindings( List<NamedClusterRoleBinding> roleBindings);    public A withRoleBindings( NamedClusterRoleBinding ...roleBindings);    public RoleBindingsNested<A> addNewRoleBinding();    public RoleBindingsNested<A> addNewRoleBindingLike( NamedClusterRoleBinding item);
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface PolicyRefNested<N> extends Nested<N>,ObjectReferenceFluent<PolicyRefNested<N>>{
            public N endPolicyRef();            public N and();        
}

    public interface RoleBindingsNested<N> extends Nested<N>,NamedClusterRoleBindingFluent<RoleBindingsNested<N>>{
            public N endRoleBinding();            public N and();        
}


}
