package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class ClusterRoleScopeRestrictionBuilder extends ClusterRoleScopeRestrictionFluentImpl<ClusterRoleScopeRestrictionBuilder> implements VisitableBuilder<ClusterRoleScopeRestriction,ClusterRoleScopeRestrictionBuilder>{

     ClusterRoleScopeRestrictionFluent<?> fluent;
public ClusterRoleScopeRestrictionBuilder(){
    this(new ClusterRoleScopeRestriction());
}
public ClusterRoleScopeRestrictionBuilder( ClusterRoleScopeRestrictionFluent<?> fluent ){
    this(fluent, new ClusterRoleScopeRestriction());
}
public ClusterRoleScopeRestrictionBuilder( ClusterRoleScopeRestrictionFluent<?> fluent , ClusterRoleScopeRestriction instance ){
    this.fluent = fluent; fluent.withAllowEscalation(instance.getAllowEscalation()); fluent.withNamespaces(instance.getNamespaces()); fluent.withRoleNames(instance.getRoleNames()); 
}
public ClusterRoleScopeRestrictionBuilder( ClusterRoleScopeRestriction instance ){
    this.fluent = this; this.withAllowEscalation(instance.getAllowEscalation()); this.withNamespaces(instance.getNamespaces()); this.withRoleNames(instance.getRoleNames()); 
}

public ClusterRoleScopeRestriction build(){
    ClusterRoleScopeRestriction buildable = new ClusterRoleScopeRestriction(fluent.isAllowEscalation(),fluent.getNamespaces(),fluent.getRoleNames());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ClusterRoleScopeRestrictionBuilder that = (ClusterRoleScopeRestrictionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
