package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class DeploymentCauseFluentImpl<A extends DeploymentCauseFluent<A>> extends BaseFluent<A> implements DeploymentCauseFluent<A>{

     VisitableBuilder<DeploymentCauseImageTrigger, ?> imageTrigger;     String type;
public DeploymentCauseFluentImpl(){
    
}
public DeploymentCauseFluentImpl( DeploymentCause instance ){
    this.withImageTrigger(instance.getImageTrigger()); this.withType(instance.getType()); 
}

    public DeploymentCauseImageTrigger getImageTrigger(){
    return this.imageTrigger!=null?this.imageTrigger.build():null;
    }
    public A withImageTrigger( DeploymentCauseImageTrigger imageTrigger){
    if (imageTrigger!=null){ this.imageTrigger= new DeploymentCauseImageTriggerBuilder(imageTrigger); _visitables.add(this.imageTrigger);} return (A) this;
    }
    public ImageTriggerNested<A> withNewImageTrigger(){
    return new ImageTriggerNestedImpl();
    }
    public ImageTriggerNested<A> withNewImageTriggerLike( DeploymentCauseImageTrigger item){
    return new ImageTriggerNestedImpl(item);
    }
    public ImageTriggerNested<A> editImageTrigger(){
    return withNewImageTriggerLike(getImageTrigger());
    }
    public String getType(){
    return this.type;
    }
    public A withType( String type){
    this.type=type; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentCauseFluentImpl that = (DeploymentCauseFluentImpl) o;
if (imageTrigger != null ? !imageTrigger.equals(that.imageTrigger) :that.imageTrigger != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
return true;

    }

    public class ImageTriggerNestedImpl<N> extends DeploymentCauseImageTriggerFluentImpl<ImageTriggerNested<N>> implements ImageTriggerNested<N>{

        private final DeploymentCauseImageTriggerBuilder builder;
    
             ImageTriggerNestedImpl (){
        this.builder = new DeploymentCauseImageTriggerBuilder(this);
        }
             ImageTriggerNestedImpl ( DeploymentCauseImageTrigger item){
        this.builder = new DeploymentCauseImageTriggerBuilder(this, item);
        }
    
            public N endImageTrigger(){
            return and();
        }
            public N and(){
            return (N) DeploymentCauseFluentImpl.this.withImageTrigger(builder.build());
        }
    
}


}
