package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface DeploymentConfigSpecFluent<A extends DeploymentConfigSpecFluent<A>> extends Fluent<A>{


    public Integer getReplicas();    public A withReplicas( Integer replicas);    public A addToSelector( String key,  String value);    public A addToSelector( Map<String, String> map);    public A removeFromSelector( String key);    public A removeFromSelector( Map<String, String> map);    public Map<String, String> getSelector();    public A withSelector( Map<String, String> selector);    public DeploymentStrategy getStrategy();    public A withStrategy( DeploymentStrategy strategy);    public StrategyNested<A> withNewStrategy();    public StrategyNested<A> withNewStrategyLike( DeploymentStrategy item);    public StrategyNested<A> editStrategy();    public PodTemplateSpec getTemplate();    public A withTemplate( PodTemplateSpec template);    public TemplateNested<A> withNewTemplate();    public TemplateNested<A> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<A> editTemplate();    public Boolean isTest();    public A withTest( Boolean test);    public A addToTriggers( DeploymentTriggerPolicy ...items);    public A removeFromTriggers( DeploymentTriggerPolicy ...items);    public List<DeploymentTriggerPolicy> getTriggers();    public A withTriggers( List<DeploymentTriggerPolicy> triggers);    public A withTriggers( DeploymentTriggerPolicy ...triggers);    public TriggersNested<A> addNewTrigger();    public TriggersNested<A> addNewTriggerLike( DeploymentTriggerPolicy item);
    public interface StrategyNested<N> extends Nested<N>,DeploymentStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}

    public interface TriggersNested<N> extends Nested<N>,DeploymentTriggerPolicyFluent<TriggersNested<N>>{
            public N endTrigger();            public N and();        
}


}
