package io.fabric8.openshift.api.model;

import java.util.List;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;

public class ExecNewPodHookFluentImpl<A extends ExecNewPodHookFluent<A>> extends BaseFluent<A> implements ExecNewPodHookFluent<A>{

     List<String> command = new ArrayList();     String containerName;     List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();     List<String> volumes = new ArrayList();
public ExecNewPodHookFluentImpl(){
    
}
public ExecNewPodHookFluentImpl( ExecNewPodHook instance ){
    this.withCommand(instance.getCommand()); this.withContainerName(instance.getContainerName()); this.withEnv(instance.getEnv()); this.withVolumes(instance.getVolumes()); 
}

    public A addToCommand( String ...items){
    for (String item : items) {this.command.add(item);} return (A)this;
    }
    public A removeFromCommand( String ...items){
    for (String item : items) {this.command.remove(item);} return (A)this;
    }
    public List<String> getCommand(){
    return this.command;
    }
    public A withCommand( List<String> command){
    this.command.clear();if (command != null) {for (String item : command){this.addToCommand(item);}} return (A) this;
    }
    public A withCommand( String ...command){
    this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (A) this;
    }
    public String getContainerName(){
    return this.containerName;
    }
    public A withContainerName( String containerName){
    this.containerName=containerName; return (A) this;
    }
    public A addToEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.env.add(builder);} return (A)this;
    }
    public A removeFromEnv( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.env.remove(builder);} return (A)this;
    }
    public List<EnvVar> getEnv(){
    return build(env);
    }
    public A withEnv( List<EnvVar> env){
    this.env.clear();if (env != null) {for (EnvVar item : env){this.addToEnv(item);}} return (A) this;
    }
    public A withEnv( EnvVar ...env){
    this.env.clear(); if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }
    public EnvNested<A> addNewEnv(){
    return new EnvNestedImpl();
    }
    public EnvNested<A> addNewEnvLike( EnvVar item){
    return new EnvNestedImpl(item);
    }
    public A addToVolumes( String ...items){
    for (String item : items) {this.volumes.add(item);} return (A)this;
    }
    public A removeFromVolumes( String ...items){
    for (String item : items) {this.volumes.remove(item);} return (A)this;
    }
    public List<String> getVolumes(){
    return this.volumes;
    }
    public A withVolumes( List<String> volumes){
    this.volumes.clear();if (volumes != null) {for (String item : volumes){this.addToVolumes(item);}} return (A) this;
    }
    public A withVolumes( String ...volumes){
    this.volumes.clear(); if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ExecNewPodHookFluentImpl that = (ExecNewPodHookFluentImpl) o;
if (command != null ? !command.equals(that.command) :that.command != null) return false;
if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
return true;

    }

    public class EnvNestedImpl<N> extends EnvVarFluentImpl<EnvNested<N>> implements EnvNested<N>{

        private final EnvVarBuilder builder;
    
             EnvNestedImpl (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvNestedImpl ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnv(){
            return and();
        }
            public N and(){
            return (N) ExecNewPodHookFluentImpl.this.addToEnv(builder.build());
        }
    
}


}
