package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class GitSourceRevisionBuilder extends GitSourceRevisionFluentImpl<GitSourceRevisionBuilder> implements VisitableBuilder<GitSourceRevision,GitSourceRevisionBuilder>{

     GitSourceRevisionFluent<?> fluent;
public GitSourceRevisionBuilder(){
    this(new GitSourceRevision());
}
public GitSourceRevisionBuilder( GitSourceRevisionFluent<?> fluent ){
    this(fluent, new GitSourceRevision());
}
public GitSourceRevisionBuilder( GitSourceRevisionFluent<?> fluent , GitSourceRevision instance ){
    this.fluent = fluent; fluent.withAuthor(instance.getAuthor()); fluent.withCommit(instance.getCommit()); fluent.withCommitter(instance.getCommitter()); fluent.withMessage(instance.getMessage()); 
}
public GitSourceRevisionBuilder( GitSourceRevision instance ){
    this.fluent = this; this.withAuthor(instance.getAuthor()); this.withCommit(instance.getCommit()); this.withCommitter(instance.getCommitter()); this.withMessage(instance.getMessage()); 
}

public GitSourceRevision build(){
    GitSourceRevision buildable = new GitSourceRevision(fluent.getAuthor(),fluent.getCommit(),fluent.getCommitter(),fluent.getMessage());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
GitSourceRevisionBuilder that = (GitSourceRevisionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    Validator validator = null;
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    } catch(ValidationException e) {
        //ignore
        return;
    }

    Set<ConstraintViolation<T>> violations = validator.validate(item);
    if (!violations.isEmpty()) {
        throw new ConstraintViolationException(violations);
    }
}

}
