package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface GitSourceRevisionFluent<A extends GitSourceRevisionFluent<A>> extends Fluent<A>{


    public SourceControlUser getAuthor();    public A withAuthor( SourceControlUser author);    public AuthorNested<A> withNewAuthor();    public AuthorNested<A> withNewAuthorLike( SourceControlUser item);    public AuthorNested<A> editAuthor();    public A withNewAuthor( String email,  String name);    public String getCommit();    public A withCommit( String commit);    public SourceControlUser getCommitter();    public A withCommitter( SourceControlUser committer);    public CommitterNested<A> withNewCommitter();    public CommitterNested<A> withNewCommitterLike( SourceControlUser item);    public CommitterNested<A> editCommitter();    public A withNewCommitter( String email,  String name);    public String getMessage();    public A withMessage( String message);
    public interface AuthorNested<N> extends Nested<N>,SourceControlUserFluent<AuthorNested<N>>{
            public N and();            public N endAuthor();        
}

    public interface CommitterNested<N> extends Nested<N>,SourceControlUserFluent<CommitterNested<N>>{
            public N and();            public N endCommitter();        
}


}
