package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class GitSourceRevisionFluentImpl<A extends GitSourceRevisionFluent<A>> extends BaseFluent<A> implements GitSourceRevisionFluent<A>{

     VisitableBuilder<SourceControlUser, ?> author;     String commit;     VisitableBuilder<SourceControlUser, ?> committer;     String message;
public GitSourceRevisionFluentImpl(){
    
}
public GitSourceRevisionFluentImpl( GitSourceRevision instance ){
    this.withAuthor(instance.getAuthor()); this.withCommit(instance.getCommit()); this.withCommitter(instance.getCommitter()); this.withMessage(instance.getMessage()); 
}

    public SourceControlUser getAuthor(){
    return this.author!=null?this.author.build():null;
    }
    public A withAuthor( SourceControlUser author){
    if (author!=null){ this.author= new SourceControlUserBuilder(author); _visitables.add(this.author);} return (A) this;
    }
    public AuthorNested<A> withNewAuthor(){
    return new AuthorNestedImpl();
    }
    public AuthorNested<A> withNewAuthorLike( SourceControlUser item){
    return new AuthorNestedImpl(item);
    }
    public AuthorNested<A> editAuthor(){
    return withNewAuthorLike(getAuthor());
    }
    public A withNewAuthor( String email,  String name){
    return withAuthor(new SourceControlUser(email, name));
    }
    public String getCommit(){
    return this.commit;
    }
    public A withCommit( String commit){
    this.commit=commit; return (A) this;
    }
    public SourceControlUser getCommitter(){
    return this.committer!=null?this.committer.build():null;
    }
    public A withCommitter( SourceControlUser committer){
    if (committer!=null){ this.committer= new SourceControlUserBuilder(committer); _visitables.add(this.committer);} return (A) this;
    }
    public CommitterNested<A> withNewCommitter(){
    return new CommitterNestedImpl();
    }
    public CommitterNested<A> withNewCommitterLike( SourceControlUser item){
    return new CommitterNestedImpl(item);
    }
    public CommitterNested<A> editCommitter(){
    return withNewCommitterLike(getCommitter());
    }
    public A withNewCommitter( String email,  String name){
    return withCommitter(new SourceControlUser(email, name));
    }
    public String getMessage(){
    return this.message;
    }
    public A withMessage( String message){
    this.message=message; return (A) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
GitSourceRevisionFluentImpl that = (GitSourceRevisionFluentImpl) o;
if (author != null ? !author.equals(that.author) :that.author != null) return false;
if (commit != null ? !commit.equals(that.commit) :that.commit != null) return false;
if (committer != null ? !committer.equals(that.committer) :that.committer != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
return true;

    }

    public class AuthorNestedImpl<N> extends SourceControlUserFluentImpl<AuthorNested<N>> implements AuthorNested<N>{

        private final SourceControlUserBuilder builder;
    
             AuthorNestedImpl (){
        this.builder = new SourceControlUserBuilder(this);
        }
             AuthorNestedImpl ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withAuthor(builder.build());
        }
            public N endAuthor(){
            return and();
        }
    
}
    public class CommitterNestedImpl<N> extends SourceControlUserFluentImpl<CommitterNested<N>> implements CommitterNested<N>{

        private final SourceControlUserBuilder builder;
    
             CommitterNestedImpl (){
        this.builder = new SourceControlUserBuilder(this);
        }
             CommitterNestedImpl ( SourceControlUser item){
        this.builder = new SourceControlUserBuilder(this, item);
        }
    
            public N and(){
            return (N) GitSourceRevisionFluentImpl.this.withCommitter(builder.build());
        }
            public N endCommitter(){
            return and();
        }
    
}


}
