package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public class IdentityFluentImpl<A extends IdentityFluent<A>> extends BaseFluent<A> implements IdentityFluent<A>{

     String apiVersion;     Map<String, String> extra = new HashMap();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     String providerName;     String providerUserName;     VisitableBuilder<ObjectReference, ?> user;
public IdentityFluentImpl(){
    
}
public IdentityFluentImpl( Identity instance ){
    this.withApiVersion(instance.getApiVersion()); this.withExtra(instance.getExtra()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withProviderName(instance.getProviderName()); this.withProviderUserName(instance.getProviderUserName()); this.withUser(instance.getUser()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public A withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (A) this;
    }
    public A addToExtra( String key,  String value){
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
    }
    public A addToExtra( Map<String, String> map){
    if(map != null) { this.extra.putAll(map);} return (A)this;
    }
    public A removeFromExtra( String key){
    if(key != null) {this.extra.remove(key);} return (A)this;
    }
    public A removeFromExtra( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.extra.remove(key);}} return (A)this;
    }
    public Map<String, String> getExtra(){
    return this.extra;
    }
    public A withExtra( Map<String, String> extra){
    this.extra.clear();if (extra != null) {this.extra.putAll(extra);} return (A) this;
    }
    public String getKind(){
    return this.kind;
    }
    public A withKind( String kind){
    this.kind=kind; return (A) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public A withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }
    public MetadataNested<A> withNewMetadata(){
    return new MetadataNestedImpl();
    }
    public MetadataNested<A> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl(item);
    }
    public MetadataNested<A> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public String getProviderName(){
    return this.providerName;
    }
    public A withProviderName( String providerName){
    this.providerName=providerName; return (A) this;
    }
    public String getProviderUserName(){
    return this.providerUserName;
    }
    public A withProviderUserName( String providerUserName){
    this.providerUserName=providerUserName; return (A) this;
    }
    public ObjectReference getUser(){
    return this.user!=null?this.user.build():null;
    }
    public A withUser( ObjectReference user){
    if (user!=null){ this.user= new ObjectReferenceBuilder(user); _visitables.add(this.user);} return (A) this;
    }
    public UserNested<A> withNewUser(){
    return new UserNestedImpl();
    }
    public UserNested<A> withNewUserLike( ObjectReference item){
    return new UserNestedImpl(item);
    }
    public UserNested<A> editUser(){
    return withNewUserLike(getUser());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IdentityFluentImpl that = (IdentityFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (providerName != null ? !providerName.equals(that.providerName) :that.providerName != null) return false;
if (providerUserName != null ? !providerUserName.equals(that.providerUserName) :that.providerUserName != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
return true;

    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
    
            public N and(){
            return (N) IdentityFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class UserNestedImpl<N> extends ObjectReferenceFluentImpl<UserNested<N>> implements UserNested<N>{

        private final ObjectReferenceBuilder builder;
    
             UserNestedImpl (){
        this.builder = new ObjectReferenceBuilder(this);
        }
             UserNestedImpl ( ObjectReference item){
        this.builder = new ObjectReferenceBuilder(this, item);
        }
    
            public N and(){
            return (N) IdentityFluentImpl.this.withUser(builder.build());
        }
            public N endUser(){
            return and();
        }
    
}


}
